/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.test.support.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public class WebsocketConsumerClientHandler
extends AbstractWebSocketHandler {
    final List<String> receivedMessages = new ArrayList<String>();
    final int waitMessageCount;
    final CountDownLatch latch;
    final long timeout;
    final String id;

    public WebsocketConsumerClientHandler(String id, int waitMessageCount, long timeout) {
        this.id = id;
        this.waitMessageCount = waitMessageCount;
        this.latch = new CountDownLatch(waitMessageCount);
        this.timeout = timeout;
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) {
        this.receivedMessages.add((String)message.getPayload());
        this.latch.countDown();
    }

    public boolean await() throws InterruptedException {
        return this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
    }

    public List<String> getReceivedMessages() {
        return this.receivedMessages;
    }
}

