/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.test.support.xmpp;

import java.time.Duration;
import org.junit.jupiter.api.BeforeAll;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers(disabledWithoutDocker=true)
public interface XmppTestContainerSupport {
    public static final String XMPP_HOST = "localhost";
    public static final String JOHN_USER = "john";
    public static final String JANE_USER = "jane";
    public static final String USER_PW = "secret";
    public static final String SERVICE_NAME = "localhost";
    public static final GenericContainer<?> XMPP_CONTAINER = new GenericContainer("fishbowler/openfire:v4.7.0").withExposedPorts(new Integer[]{5222}).withClasspathResourceMapping("xmpp/conf", "/var/lib/openfire/conf", BindMode.READ_ONLY).withCommand("-demoboot").withStartupTimeout(Duration.ofSeconds(120L)).withStartupAttempts(3);

    @BeforeAll
    public static void startContainer() {
        XMPP_CONTAINER.start();
    }

    public static String getXmppHost() {
        return "localhost";
    }

    public static Integer getXmppMappedPort() {
        return XMPP_CONTAINER.getFirstMappedPort();
    }
}

