/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.consumer.websocket;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.fn.consumer.websocket.WebsocketConsumerProperties;
import org.springframework.cloud.fn.consumer.websocket.WebsocketConsumerServerInitializer;

public class WebsocketConsumerServer {
    private static final Log LOGGER = LogFactory.getLog(WebsocketConsumerServer.class);
    static final List<Channel> CHANNELS = new CopyOnWriteArrayList<Channel>();
    private final WebsocketConsumerProperties properties;
    private final WebsocketConsumerServerInitializer initializer;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private int port;

    public WebsocketConsumerServer(WebsocketConsumerProperties properties, WebsocketConsumerServerInitializer initializer) {
        this.properties = properties;
        this.initializer = initializer;
    }

    public int getPort() {
        return this.port;
    }

    @PostConstruct
    public void init() {
        this.bossGroup = new NioEventLoopGroup(this.properties.getThreads());
        this.workerGroup = new NioEventLoopGroup();
    }

    @PreDestroy
    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public void run() throws InterruptedException {
        NioServerSocketChannel channel = (NioServerSocketChannel)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(this.nettyLogLevel()))).childHandler((ChannelHandler)this.initializer).bind(this.properties.getPort()).sync().channel();
        this.port = channel.localAddress().getPort();
        this.dumpProperties();
    }

    private void dumpProperties() {
        LOGGER.info((Object)"\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
        LOGGER.info((Object)"                >> websocket-sink config <<                ");
        LOGGER.info((Object)"");
        LOGGER.info((Object)String.format("port:     %s", this.port));
        LOGGER.info((Object)String.format("ssl:               %s", this.properties.isSsl()));
        LOGGER.info((Object)String.format("path:     %s", this.properties.getPath()));
        LOGGER.info((Object)String.format("logLevel: %s", this.properties.getLogLevel()));
        LOGGER.info((Object)String.format("threads:           %s", this.properties.getThreads()));
        LOGGER.info((Object)"");
        LOGGER.info((Object)"\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
    }

    private LogLevel nettyLogLevel() {
        return LogLevel.valueOf((String)this.properties.getLogLevel().toUpperCase());
    }
}

