/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.consumer.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.fn.consumer.websocket.WebsocketConsumerProperties;
import org.springframework.cloud.fn.consumer.websocket.WebsocketConsumerServer;
import org.springframework.cloud.fn.consumer.websocket.trace.InMemoryTraceRepository;

public class WebsocketConsumerServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Log LOGGER = LogFactory.getLog(WebsocketConsumerServerHandler.class);
    private final boolean traceEnabled;
    private final InMemoryTraceRepository websocketTraceRepository;
    private final WebsocketConsumerProperties properties;
    private WebSocketServerHandshaker handshaker;

    public WebsocketConsumerServerHandler(InMemoryTraceRepository websocketTraceRepository, WebsocketConsumerProperties properties, boolean traceEnabled) {
        this.websocketTraceRepository = websocketTraceRepository;
        this.properties = properties;
        this.traceEnabled = traceEnabled;
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.decoderResult().isSuccess()) {
            LOGGER.warn((Object)String.format("Bad request: %s", req.uri()));
            this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (req.method() != HttpMethod.GET) {
            LOGGER.warn((Object)String.format("Unsupported HTTP method: %s", req.method()));
            this.sendHttpResponse(ctx, req, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        if (!this.additionalHttpRequestHandler(ctx, req)) {
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(req), null, true);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), req);
            WebsocketConsumerServer.CHANNELS.add(ctx.channel());
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.addTraceForFrame(frame, "close");
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            this.addTraceForFrame(frame, "ping");
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        this.handleTextWebSocketFrameInternal((TextWebSocketFrame)frame, ctx);
    }

    private boolean additionalHttpRequestHandler(ChannelHandlerContext ctx, FullHttpRequest req) {
        return true;
    }

    private void handleTextWebSocketFrameInternal(TextWebSocketFrame frame, ChannelHandlerContext ctx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)String.format("%s received %s", ctx.channel(), frame.text()));
        }
        this.addTraceForFrame((WebSocketFrame)frame, "text");
        ctx.channel().write((Object)new TextWebSocketFrame("Echo: " + frame.text()));
    }

    private void addTraceForFrame(WebSocketFrame frame, String type) {
        LinkedHashMap<String, Object> trace = new LinkedHashMap<String, Object>();
        trace.put("type", type);
        trace.put("direction", "in");
        if (frame instanceof TextWebSocketFrame) {
            trace.put("payload", ((TextWebSocketFrame)frame).text());
        }
        if (this.traceEnabled) {
            this.websocketTraceRepository.add(trace);
        }
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        if (res.status().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
            HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error((Object)"Websocket error", cause);
        ctx.close();
    }

    private String getWebSocketLocation(FullHttpRequest req) {
        String location = req.headers().get((CharSequence)HttpHeaderNames.HOST) + this.properties.getPath();
        if (this.properties.isSsl()) {
            return "wss://" + location;
        }
        return "ws://" + location;
    }
}

