/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.consumer.websocket.actuator;

import jakarta.annotation.PostConstruct;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.fn.consumer.websocket.trace.InMemoryTraceRepository;
import org.springframework.cloud.fn.consumer.websocket.trace.Trace;

@ConfigurationProperties(prefix="endpoints.websocketconsumertrace")
@Endpoint(id="websocketconsumertrace")
public class WebsocketConsumerTraceEndpoint {
    private static final Log LOGGER = LogFactory.getLog(WebsocketConsumerTraceEndpoint.class);
    private boolean enabled;
    private final InMemoryTraceRepository repository;

    public WebsocketConsumerTraceEndpoint(InMemoryTraceRepository repository) {
        this.repository = repository;
        LOGGER.info((Object)String.format("/websocketsinktrace enabled: %b", this.enabled));
    }

    @PostConstruct
    public void init() {
    }

    @ReadOperation
    public List<Trace> traces() {
        return this.repository.findAll();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

