/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.task.launch.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

abstract class KeyValueListParser {
    KeyValueListParser() {
    }

    static Map<String, String> parseCommaDelimitedKeyValuePairs(String value) {
        HashMap<String, String> keyValuePairs = new HashMap<String, String>();
        if (StringUtils.isEmpty((Object)value)) {
            return keyValuePairs;
        }
        ArrayList<String> pairs = new ArrayList<String>();
        String[] candidates = StringUtils.commaDelimitedListToStringArray((String)value);
        for (int i = 0; i < candidates.length; ++i) {
            if (i > 0 && !candidates[i].contains("=")) {
                pairs.add((String)pairs.get(pairs.size() - 1) + "," + candidates[i]);
                continue;
            }
            pairs.add(candidates[i]);
        }
        for (String pair : pairs) {
            KeyValueListParser.addKeyValuePair(pair, keyValuePairs);
        }
        return keyValuePairs;
    }

    private static void addKeyValuePair(String pair, Map<String, String> properties) {
        int firstEquals = pair.indexOf(61);
        if (firstEquals != -1) {
            properties.put(pair.substring(0, firstEquals).trim(), pair.substring(firstEquals + 1).trim());
        }
    }
}

