/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.task.launch.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.fn.task.launch.request.CommandLineArgumentsMessageMapper;
import org.springframework.cloud.fn.task.launch.request.KeyValueListParser;
import org.springframework.cloud.fn.task.launch.request.TaskLaunchRequestFunction;
import org.springframework.cloud.fn.task.launch.request.TaskLaunchRequestFunctionProperties;
import org.springframework.cloud.fn.task.launch.request.TaskLaunchRequestMessageProcessor;
import org.springframework.cloud.fn.task.launch.request.TaskLaunchRequestSupplier;
import org.springframework.cloud.fn.task.launch.request.TaskNameMessageMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={TaskLaunchRequestFunctionProperties.class})
public class TaskLaunchRequestFunctionConfiguration {
    public static final String TASK_LAUNCH_REQUEST_FUNCTION_NAME = "taskLaunchRequestFunction";

    @Bean(name={"taskLaunchRequestFunction"})
    public TaskLaunchRequestFunction taskLaunchRequest(TaskLaunchRequestMessageProcessor taskLaunchRequestMessageProcessor) {
        return message -> taskLaunchRequestMessageProcessor.postProcessMessage((Message<?>)message);
    }

    @Bean
    public TaskLaunchRequestSupplier taskLaunchRequestInitializer(TaskLaunchRequestFunctionProperties taskLaunchRequestProperties) {
        return new TaskLaunchRequestPropertiesInitializer(taskLaunchRequestProperties);
    }

    @Bean
    public TaskLaunchRequestMessageProcessor taskLaunchRequestMessageProcessor(TaskLaunchRequestSupplier taskLaunchRequestInitializer, TaskLaunchRequestFunctionProperties properties, EvaluationContext evaluationContext, @Nullable TaskNameMessageMapper taskNameMessageMapper, @Nullable CommandLineArgumentsMessageMapper commandLineArgumentsMessageMapper) {
        if (taskNameMessageMapper == null) {
            taskNameMessageMapper = this.taskNameMessageMapper(properties, evaluationContext);
        }
        if (commandLineArgumentsMessageMapper == null) {
            commandLineArgumentsMessageMapper = this.commandLineArgumentsMessageMapper(properties, evaluationContext);
        }
        return new TaskLaunchRequestMessageProcessor(taskLaunchRequestInitializer, taskNameMessageMapper, commandLineArgumentsMessageMapper);
    }

    @Bean
    public EvaluationContext evaluationContext(BeanFactory beanFactory) {
        return ExpressionUtils.createStandardEvaluationContext((BeanFactory)beanFactory);
    }

    private TaskNameMessageMapper taskNameMessageMapper(TaskLaunchRequestFunctionProperties taskLaunchRequestProperties, EvaluationContext evaluationContext) {
        if (StringUtils.hasText((String)taskLaunchRequestProperties.getTaskNameExpression())) {
            SpelExpressionParser expressionParser = new SpelExpressionParser();
            Expression taskNameExpression = expressionParser.parseExpression(taskLaunchRequestProperties.getTaskNameExpression());
            return new ExpressionEvaluatingTaskNameMessageMapper(taskNameExpression, evaluationContext);
        }
        return message -> taskLaunchRequestProperties.getTaskName();
    }

    private CommandLineArgumentsMessageMapper commandLineArgumentsMessageMapper(TaskLaunchRequestFunctionProperties taskLaunchRequestFunctionProperties, EvaluationContext evaluationContext) {
        return new ExpressionEvaluatingCommandLineArgsMapper(taskLaunchRequestFunctionProperties.getArgExpressions(), evaluationContext);
    }

    private static class ExpressionEvaluatingCommandLineArgsMapper
    implements CommandLineArgumentsMessageMapper {
        private final Map<String, Expression> argExpressionsMap;
        private final EvaluationContext evaluationContext;

        ExpressionEvaluatingCommandLineArgsMapper(String argExpressions, EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
            this.argExpressionsMap = new HashMap<String, Expression>();
            if (StringUtils.hasText((String)argExpressions)) {
                SpelExpressionParser expressionParser = new SpelExpressionParser();
                KeyValueListParser.parseCommaDelimitedKeyValuePairs(argExpressions).forEach((k, v) -> this.argExpressionsMap.put((String)k, expressionParser.parseExpression(v)));
            }
        }

        public Collection<String> processMessage(Message<?> message) {
            return this.evaluateArgExpressions(message);
        }

        private Collection<String> evaluateArgExpressions(Message<?> message) {
            LinkedList<String> results = new LinkedList<String>();
            this.argExpressionsMap.forEach((k, expression) -> results.add(String.format("%s=%s", k, expression.getValue(this.evaluationContext, (Object)message))));
            return results;
        }
    }

    private static class ExpressionEvaluatingTaskNameMessageMapper
    implements TaskNameMessageMapper {
        private final Expression expression;
        private final EvaluationContext evaluationContext;

        ExpressionEvaluatingTaskNameMessageMapper(Expression expression, EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
            this.expression = expression;
        }

        public String processMessage(Message<?> message) {
            return this.expression.getValue(this.evaluationContext, message).toString();
        }
    }

    private static class TaskLaunchRequestPropertiesInitializer
    extends TaskLaunchRequestSupplier {
        TaskLaunchRequestPropertiesInitializer(TaskLaunchRequestFunctionProperties taskLaunchRequestProperties) {
            this.commandLineArgumentSupplier(() -> new ArrayList<String>(taskLaunchRequestProperties.getArgs()));
            this.deploymentPropertiesSupplier(() -> KeyValueListParser.parseCommaDelimitedKeyValuePairs(taskLaunchRequestProperties.getDeploymentProperties()));
            this.taskNameSupplier(() -> taskLaunchRequestProperties.getTaskName());
        }
    }
}

