/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.task.launch.request;

import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.fn.task.launch.request.CommandLineArgumentsMessageMapper;
import org.springframework.cloud.fn.task.launch.request.TaskLaunchRequest;
import org.springframework.cloud.fn.task.launch.request.TaskLaunchRequestSupplier;
import org.springframework.cloud.fn.task.launch.request.TaskNameMessageMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

class TaskLaunchRequestMessageProcessor
implements MessagePostProcessor {
    private final TaskNameMessageMapper taskNameMessageMapper;
    private final CommandLineArgumentsMessageMapper commandLineArgumentsMessageMapper;
    private final TaskLaunchRequestSupplier taskLaunchRequestInitializer;

    TaskLaunchRequestMessageProcessor(TaskLaunchRequestSupplier taskLaunchRequestInitializer, TaskNameMessageMapper taskNameMessageMapper, CommandLineArgumentsMessageMapper commandLIneArgumentsMessageMapper) {
        this.taskLaunchRequestInitializer = taskLaunchRequestInitializer;
        this.taskNameMessageMapper = taskNameMessageMapper;
        this.commandLineArgumentsMessageMapper = commandLIneArgumentsMessageMapper;
    }

    public Message<TaskLaunchRequest> postProcessMessage(Message<?> message) {
        TaskLaunchRequest taskLaunchRequest = this.taskLaunchRequestInitializer.get();
        if (!StringUtils.hasText((String)taskLaunchRequest.getTaskName())) {
            taskLaunchRequest.setTaskName((String)this.taskNameMessageMapper.processMessage(message));
            Assert.hasText((String)taskLaunchRequest.getTaskName(), () -> "'taskName' is required in " + TaskLaunchRequest.class.getName());
        }
        taskLaunchRequest.addCommmandLineArguments((Collection)this.commandLineArgumentsMessageMapper.processMessage(message));
        MessageBuilder builder = MessageBuilder.withPayload((Object)taskLaunchRequest).copyHeaders((Map)message.getHeaders());
        return this.adjustHeaders((MessageBuilder<TaskLaunchRequest>)builder).build();
    }

    private MessageBuilder<TaskLaunchRequest> adjustHeaders(MessageBuilder<TaskLaunchRequest> builder) {
        builder.setHeader("contentType", (Object)MimeTypeUtils.APPLICATION_JSON);
        return builder;
    }
}

