/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.task.launch.request;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.cloud.fn.task.launch.request.TaskLaunchRequest;
import org.springframework.util.Assert;

class TaskLaunchRequestSupplier
implements Supplier<TaskLaunchRequest> {
    private Supplier<String> taskNameSupplier;
    private Supplier<List<String>> commandLineArgumentsSupplier;
    private Supplier<Map<String, String>> deploymentPropertiesSupplier;

    TaskLaunchRequestSupplier() {
    }

    public TaskLaunchRequestSupplier taskNameSupplier(Supplier<String> taskNameSupplier) {
        this.taskNameSupplier = taskNameSupplier;
        return this;
    }

    public TaskLaunchRequestSupplier commandLineArgumentSupplier(Supplier<List<String>> commandLineArgumentsSupplier) {
        this.commandLineArgumentsSupplier = commandLineArgumentsSupplier;
        return this;
    }

    public TaskLaunchRequestSupplier deploymentPropertiesSupplier(Supplier<Map<String, String>> deploymentPropertiesSupplier) {
        this.deploymentPropertiesSupplier = deploymentPropertiesSupplier;
        return this;
    }

    @Override
    public TaskLaunchRequest get() {
        Assert.notNull(this.taskNameSupplier, (String)"'taskNameSupplier' is required.");
        TaskLaunchRequest taskLaunchRequest = new TaskLaunchRequest();
        taskLaunchRequest.setTaskName(this.taskNameSupplier.get());
        if (this.commandLineArgumentsSupplier != null) {
            taskLaunchRequest.setCommandlineArguments(this.commandLineArgumentsSupplier.get());
        }
        if (this.deploymentPropertiesSupplier != null) {
            taskLaunchRequest.setDeploymentProperties(this.deploymentPropertiesSupplier.get());
        }
        return taskLaunchRequest;
    }
}

