/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.cache;

import com.amazonaws.services.elasticache.AmazonElastiCache;
import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.Endpoint;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cache.Cache;
import org.springframework.cloud.aws.cache.CacheFactory;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;

public class ElastiCacheFactoryBean
extends AbstractFactoryBean<Cache> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElastiCacheFactoryBean.class);
    private final AmazonElastiCache amazonElastiCache;
    private final String cacheClusterId;
    private final ResourceIdResolver resourceIdResolver;
    private final List<? extends CacheFactory> cacheFactories;

    public ElastiCacheFactoryBean(AmazonElastiCache amazonElastiCache, String cacheClusterId, ResourceIdResolver resourceIdResolver, List<? extends CacheFactory> cacheFactories) {
        this.amazonElastiCache = amazonElastiCache;
        this.resourceIdResolver = resourceIdResolver;
        this.cacheClusterId = cacheClusterId;
        this.cacheFactories = cacheFactories;
    }

    public ElastiCacheFactoryBean(AmazonElastiCache amazonElastiCache, String cacheClusterId, List<CacheFactory> cacheFactories) {
        this(amazonElastiCache, cacheClusterId, null, cacheFactories);
    }

    public Class<Cache> getObjectType() {
        return Cache.class;
    }

    protected Cache createInstance() throws Exception {
        DescribeCacheClustersResult describeCacheClustersResult = this.amazonElastiCache.describeCacheClusters(new DescribeCacheClustersRequest().withCacheClusterId(this.getCacheClusterName()));
        CacheCluster cacheCluster = (CacheCluster)describeCacheClustersResult.getCacheClusters().get(0);
        if (!"available".equals(cacheCluster.getCacheClusterStatus())) {
            LOGGER.warn("Cache cluster is not available now. Connection may fail during cache access. Current status is {}", (Object)cacheCluster.getCacheClusterStatus());
        }
        for (CacheFactory cacheFactory : this.cacheFactories) {
            if (!cacheFactory.isSupportingCacheArchitecture(cacheCluster.getEngine())) continue;
            Endpoint configurationEndpoint = cacheCluster.getConfigurationEndpoint();
            return cacheFactory.createCache(this.cacheClusterId, configurationEndpoint.getAddress(), configurationEndpoint.getPort());
        }
        throw new IllegalArgumentException("No CacheFactory configured for engine: " + cacheCluster.getEngine());
    }

    protected void destroyInstance(Cache instance) throws Exception {
        if (instance instanceof DisposableBean) {
            ((DisposableBean)instance).destroy();
        }
    }

    private String getCacheClusterName() {
        return this.resourceIdResolver != null ? this.resourceIdResolver.resolveToPhysicalResourceId(this.cacheClusterId) : this.cacheClusterId;
    }
}

