/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.support.io;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ResourceLoaderBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
BeanFactoryPostProcessor {
    private final ResourceLoader resourceLoader;
    private ApplicationContext applicationContextProxy;

    public ResourceLoaderBeanPostProcessor(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof GenericApplicationContext) {
            ((GenericApplicationContext)applicationContext).setResourceLoader(this.resourceLoader);
        } else {
            this.applicationContextProxy = this.getApplicationContextProxy(applicationContext);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)bean).setResourceLoader(this.resourceLoader);
        }
        if (this.applicationContextProxy != null && bean instanceof ApplicationContextAware && !(bean instanceof ApplicationObjectSupport)) {
            ((ApplicationContextAware)bean).setApplicationContext(this.applicationContextProxy);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected ApplicationContext getApplicationContextProxy(ApplicationContext target) {
        Class[] interfaces = ClassUtils.getAllInterfaces((Object)target);
        return (ApplicationContext)Proxy.newProxyInstance(target.getClassLoader(), interfaces, (InvocationHandler)new ResourceLoaderInvocationHandler(this.resourceLoader, target));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.applicationContextProxy != null) {
            beanFactory.registerResolvableDependency(ApplicationContext.class, (Object)this.applicationContextProxy);
        }
        beanFactory.registerResolvableDependency(ResourceLoader.class, (Object)this.resourceLoader);
    }

    private static class ResourceLoaderInvocationHandler
    implements InvocationHandler {
        private final ResourceLoader resourceLoader;
        private final ApplicationContext delegate;

        private ResourceLoaderInvocationHandler(ResourceLoader resourceLoader, ApplicationContext delegate) {
            this.resourceLoader = resourceLoader;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == ResourceLoader.class) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)this.resourceLoader, (Object[])args);
            }
            return ReflectionUtils.invokeMethod((Method)method, (Object)this.delegate, (Object[])args);
        }
    }
}

