/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class Main {
    public static void main(String ... args) {
        String outputFile = args[0];
        String inclusionPattern = args.length > 1 ? args[1] : ".*";
        File parent = new File(outputFile).getParentFile();
        if (!parent.exists()) {
            System.out.println("No parent directory [" + parent.toString() + "] found. Will not generate the configuration properties file");
            return;
        }
        new Generator().generate(outputFile, inclusionPattern);
    }

    static class ConfigValue {
        public String name;
        public String description;
        public String defaultValue;

        ConfigValue() {
        }

        ConfigValue(String name, Object description, Object defaultValue) {
            this.name = name;
            this.description = this.escapedValue(description);
            this.defaultValue = this.escapedValue(defaultValue);
        }

        private String escapedValue(Object value) {
            return value != null ? value.toString().replaceAll("\\|", "\\\\|") : "";
        }

        public String toString() {
            return "|" + this.name + " | " + (StringUtils.hasText((String)this.defaultValue) ? "`" + this.defaultValue + "`" : "") + " | " + this.description;
        }
    }

    static class Generator {
        Generator() {
        }

        void generate(String outputFile, String inclusionPattern) {
            try {
                System.out.println("Parsing all configuration metadata");
                Resource[] resources = this.getResources();
                System.out.println("Found [" + resources.length + "] configuration metadata jsons");
                TreeSet names = new TreeSet();
                HashMap descriptions = new HashMap();
                AtomicInteger count = new AtomicInteger();
                AtomicInteger matchingPropertyCount = new AtomicInteger();
                AtomicInteger propertyCount = new AtomicInteger();
                Pattern pattern = Pattern.compile(inclusionPattern);
                for (Resource resource : resources) {
                    if (!this.resourceNameContainsPattern(resource)) continue;
                    count.incrementAndGet();
                    byte[] bytes = StreamUtils.copyToByteArray((InputStream)resource.getInputStream());
                    Map response = (Map)new ObjectMapper().readValue(bytes, HashMap.class);
                    List properties = (List)response.get("properties");
                    properties.forEach(val -> {
                        propertyCount.incrementAndGet();
                        String name = String.valueOf(val.get("name"));
                        if (!pattern.matcher(name).matches()) {
                            return;
                        }
                        Object description = val.get("description");
                        Object defaultValue = val.get("defaultValue");
                        matchingPropertyCount.incrementAndGet();
                        names.add(name);
                        descriptions.put(name, new ConfigValue(name, description, defaultValue));
                    });
                }
                System.out.println("Found [" + count + "] Cloud projects configuration metadata jsons. [" + matchingPropertyCount + "/" + propertyCount + "] were matching the pattern [" + inclusionPattern + "]");
                System.out.println("Successfully built the description table");
                if (names.isEmpty()) {
                    System.out.println("Will not update the table, since no configuration properties were found!");
                    return;
                }
                Files.write(new File(outputFile).toPath(), ("|===\n|Name | Default | Description\n\n" + names.stream().map(it -> ((ConfigValue)descriptions.get(it)).toString()).collect(Collectors.joining("\n")) + "\n\n|===").getBytes(), new OpenOption[0]);
                System.out.println("Successfully stored the output file");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        protected boolean resourceNameContainsPattern(Resource resource) {
            try {
                return resource.getURL().toString().contains("cloud");
            }
            catch (Exception e) {
                System.out.println("Exception [" + e + "] for resource [" + resource + "] occurred while trying to retrieve its URL");
                return false;
            }
        }

        protected Resource[] getResources() throws IOException {
            return new PathMatchingResourcePatternResolver().getResources("classpath*:/META-INF/spring-configuration-metadata.json");
        }
    }
}

