/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal.asciidoctor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.Preprocessor;
import org.springframework.cloud.internal.asciidoctor.CoalescerPreprocessor;

public class ReadmeMain {
    public static void main(String ... args) {
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        System.out.println("Will do the Readme conversion from [" + inputFile + "] to [" + outputFile + "]");
        if (!inputFile.exists()) {
            System.out.println("There's no file [" + inputFile + "], skipping readme generation");
            return;
        }
        new ReadmeMain().convert(inputFile, outputFile);
    }

    void convert(File input, File output) {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        asciidoctor.javaExtensionRegistry().preprocessor((Preprocessor)new CoalescerPreprocessor(output));
        Options options = this.options(input, output);
        try {
            String fileAsString = new String(Files.readAllBytes(input.toPath()));
            asciidoctor.convert(fileAsString, options);
            System.out.println("Successfully converted the Readme file!\n");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to convert the file", ex);
        }
    }

    private Options options(File input, File output) {
        Attributes attributes = new Attributes();
        attributes.setAllowUriRead(true);
        attributes.setAttribute("project-root", (Object)output.getParent());
        Options options = new Options();
        options.setSourceDir(input.getParent());
        options.setBaseDir(input.getParent());
        options.setAttributes(attributes);
        options.setSafe(SafeMode.UNSAFE);
        options.setParseHeaderOnly(true);
        return options;
    }
}

