/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.internal.asciidoctor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.PreprocessorReader;

class CoalescerPreprocessor
extends Preprocessor {
    private final File outputFile;
    private static final List<String> FILTER_LICENSE_MARKERS = Arrays.asList("[preface]", "<<<");
    private static final String COMMENT_MARKER = "//";
    private static final String SOURCE_MARKER = "[source";
    private static final List<String> SECTION_MARKERS = Arrays.asList("----", "....");
    private static final String HEADER = "////\nDO NOT EDIT THIS FILE. IT WAS GENERATED.\nManual changes to this file will be lost when it is generated again.\nEdit the files in the src/main/asciidoc/ directory instead.\n////\n\n";

    CoalescerPreprocessor(File output_file) {
        this.outputFile = output_file;
    }

    public void process(Document document, PreprocessorReader preprocessorReader) {
        try {
            LinkedList<String> filteredLines = this.filterLines(preprocessorReader.readLines());
            filteredLines.addFirst(HEADER);
            Files.write(this.outputFile.toPath(), filteredLines, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write the preprocessed file " + this.outputFile, e);
        }
    }

    private LinkedList<String> filterLines(List<String> lines) {
        LinkedList<String> filteredLines = new LinkedList<String>();
        ParsingState state = ParsingState.NORMAL;
        int counter = 0;
        block6: for (String line : lines) {
            ++counter;
            switch (state) {
                case NORMAL: {
                    if (FILTER_LICENSE_MARKERS.contains(line)) {
                        state = ParsingState.FILTER_LICENSE;
                        break;
                    }
                    if (!line.startsWith(SOURCE_MARKER)) break;
                    state = ParsingState.SOURCE;
                    break;
                }
                case SOURCE: {
                    if (SECTION_MARKERS.contains(line)) {
                        state = ParsingState.SOURCE_CONTENT;
                        break;
                    }
                    System.err.println("[source] requires to be followed by a section marker and line number [" + counter + "] with content [" + line + "] doesn't have it");
                    break;
                }
                case SOURCE_CONTENT: {
                    if (SECTION_MARKERS.contains(line)) {
                        state = ParsingState.NORMAL;
                        break;
                    }
                    filteredLines.add(line.replaceAll("\t", "    "));
                    continue block6;
                }
                case FILTER_LICENSE: {
                    if (line.startsWith(COMMENT_MARKER)) continue block6;
                    state = ParsingState.NORMAL;
                }
            }
            filteredLines.add(line);
        }
        return filteredLines;
    }

    private static enum ParsingState {
        NORMAL,
        FILTER_LICENSE,
        SOURCE,
        SOURCE_CONTENT;

    }
}

