/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.actuator.FeaturesEndpoint;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.context.annotation.Bean;

public class CommonsClientAutoConfigurationTests {
    ApplicationContextRunner applicationContextRunner = (ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{CommonsClientAutoConfiguration.class, SimpleDiscoveryClientAutoConfiguration.class, UtilAutoConfiguration.class}));

    @Test
    public void beansCreatedNormally() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.applicationContextRunner.withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{HealthEndpointAutoConfiguration.class}))).withPropertyValues(new String[]{"management.endpoints.web.exposure.include=features"})).run(ctxt -> {
            BDDAssertions.then((Object)ctxt.getBean(DiscoveryClientHealthIndicator.class)).isNotNull();
            BDDAssertions.then((Iterable)((Iterable)ctxt.getBean(DiscoveryCompositeHealthContributor.class))).isNotNull();
            BDDAssertions.then((Object)ctxt.getBean(FeaturesEndpoint.class)).isNotNull();
            BDDAssertions.then(ctxt.getBeansOfType(HasFeatures.class).values()).isNotEmpty();
        });
    }

    @Test
    public void disableAll() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.enabled=false", "management.endpoints.web.exposure.include=features"})).run(ctxt -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryCompositeHealthContributor.class);
            BDDAssertions.then((Object)ctxt.getBean(FeaturesEndpoint.class)).isNotNull();
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(HasFeatures.class);
        });
    }

    @Test
    public void disableBlocking() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.blocking.enabled=false", "management.endpoints.web.exposure.include=features"})).run(ctxt -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryCompositeHealthContributor.class);
            BDDAssertions.then((Object)ctxt.getBean(FeaturesEndpoint.class)).isNotNull();
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(HasFeatures.class);
        });
    }

    @Test
    public void disableAllIndividually() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.client.health-indicator.enabled=false", "spring.cloud.discovery.client.composite-indicator.enabled=false", "spring.cloud.features.enabled=false"})).run(ctxt -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryCompositeHealthContributor.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(FeaturesEndpoint.class);
        });
    }

    @Test
    public void disableHealthIndicator() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.client.health-indicator.enabled=false"})).run(ctxt -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)ctxt)).doesNotHaveBean(DiscoveryCompositeHealthContributor.class);
        });
    }

    @Test
    public void worksWithoutActuator() {
        ((ApplicationContextRunner)this.applicationContextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new String[]{"org.springframework.boot.actuate"}))).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(DiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(DiscoveryCompositeHealthContributor.class);
            BDDAssertions.then(context.getBeansOfType(HasFeatures.class).values()).isEmpty();
        });
    }

    @Test
    public void conditionalOnDiscoveryEnabledWorks() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.applicationContextRunner.withUserConfiguration(new Class[]{DiscoveryEnabledConfig.class})).withPropertyValues(new String[]{"spring.cloud.discovery.enabled=false"})).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(TestBean.class));
        ((ApplicationContextRunner)((ApplicationContextRunner)this.applicationContextRunner.withUserConfiguration(new Class[]{DiscoveryEnabledConfig.class})).withPropertyValues(new String[]{"spring.cloud.discovery.enabled=true"})).run(context -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)context.getBean(TestBean.class)).isNotNull();
        });
    }

    @Test
    public void conditionalOnBlockingDiscoveryEnabledWorks() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.applicationContextRunner.withUserConfiguration(new Class[]{BlockingDiscoveryEnabledConfig.class})).withPropertyValues(new String[]{"spring.cloud.discovery.blocking.enabled=false"})).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(TestBean.class));
        ((ApplicationContextRunner)((ApplicationContextRunner)this.applicationContextRunner.withUserConfiguration(new Class[]{BlockingDiscoveryEnabledConfig.class})).withPropertyValues(new String[]{"spring.cloud.discovery.blocking.enabled=true"})).run(context -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)context.getBean(TestBean.class)).isNotNull();
        });
    }

    private static class TestBean {
        private TestBean() {
        }
    }

    @TestConfiguration
    @ConditionalOnBlockingDiscoveryEnabled
    protected static class BlockingDiscoveryEnabledConfig {
        protected BlockingDiscoveryEnabledConfig() {
        }

        @Bean
        TestBean testBean() {
            return new TestBean();
        }
    }

    @TestConfiguration
    @ConditionalOnDiscoveryEnabled
    protected static class DiscoveryEnabledConfig {
        protected DiscoveryEnabledConfig() {
        }

        @Bean
        TestBean testBean() {
            return new TestBean();
        }
    }
}

