/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.actuator.FeaturesEndpoint;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.context.annotation.Bean;

public class ReactiveCommonsClientAutoConfigurationTests {
    ApplicationContextRunner applicationContextRunner = (ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{CommonsClientAutoConfiguration.class, SimpleReactiveDiscoveryClientAutoConfiguration.class, UtilAutoConfiguration.class, ReactiveCommonsClientAutoConfiguration.class}));

    @Test
    public void beansCreatedNormally() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"management.endpoints.web.exposure.include=features"})).run(context -> {
            BDDAssertions.then((Object)context.getBean(ReactiveDiscoveryClientHealthIndicator.class)).isNotNull();
            BDDAssertions.then((Iterable)((Iterable)context.getBean(ReactiveDiscoveryCompositeHealthContributor.class))).isNotNull();
            BDDAssertions.then((Object)context.getBean(FeaturesEndpoint.class)).isNotNull();
            BDDAssertions.then(context.getBeansOfType(HasFeatures.class).values()).isNotEmpty();
        });
    }

    @Test
    public void disableAll() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.enabled=false", "management.endpoints.web.exposure.include=features"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryCompositeHealthContributor.class);
            BDDAssertions.then((Object)context.getBean(FeaturesEndpoint.class)).isNotNull();
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(HasFeatures.class);
        });
    }

    @Test
    public void disableReactive() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.reactive.enabled=false", "management.endpoints.web.exposure.include=features"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryCompositeHealthContributor.class);
            BDDAssertions.then((Object)context.getBean(FeaturesEndpoint.class)).isNotNull();
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(HasFeatures.class);
        });
    }

    @Test
    public void disableAllIndividually() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.client.health-indicator.enabled=false", "spring.cloud.discovery.client.composite-indicator.enabled=false", "spring.cloud.features.enabled=false"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryCompositeHealthContributor.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(FeaturesEndpoint.class);
        });
    }

    @Test
    public void disableHealthIndicator() {
        ((ApplicationContextRunner)this.applicationContextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.client.health-indicator.enabled=false"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryCompositeHealthContributor.class);
        });
    }

    @Test
    public void worksWithoutActuator() {
        ((ApplicationContextRunner)this.applicationContextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new String[]{"org.springframework.boot.actuate"}))).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryCompositeHealthContributor.class);
            BDDAssertions.then(context.getBeansOfType(HasFeatures.class).values()).isEmpty();
        });
    }

    @Test
    public void worksWithoutWebflux() {
        ((ApplicationContextRunner)this.applicationContextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new String[]{"org.springframework.web.reactive"}))).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryClientHealthIndicator.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(ReactiveDiscoveryCompositeHealthContributor.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(HasFeatures.class);
        });
    }

    @Test
    public void conditionalOnReactiveDiscoveryEnabledWorks() {
        ApplicationContextRunner contextRunner = (ApplicationContextRunner)new ApplicationContextRunner().withUserConfiguration(new Class[]{ReactiveDiscoveryEnabledConfig.class});
        ((ApplicationContextRunner)contextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.reactive.enabled=false"})).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean(TestBean.class));
        ((ApplicationContextRunner)contextRunner.withPropertyValues(new String[]{"spring.cloud.discovery.reactive.enabled=true"})).run(context -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)context.getBean(TestBean.class)).isNotNull();
        });
    }

    private static class TestBean {
        private TestBean() {
        }
    }

    @TestConfiguration
    @ConditionalOnReactiveDiscoveryEnabled
    protected static class ReactiveDiscoveryEnabledConfig {
        protected ReactiveDiscoveryEnabledConfig() {
        }

        @Bean
        TestBean testBean() {
            return new TestBean();
        }
    }

    @TestConfiguration
    @ConditionalOnDiscoveryEnabled
    protected static class DiscoveryEnabledConfig {
        protected DiscoveryEnabledConfig() {
        }

        @Bean
        TestBean testBean() {
            return new TestBean();
        }
    }
}

