/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration
public class CompositeDiscoveryClientTestsConfig {
    static final String DEFAULT_ORDER_DISCOVERY_CLIENT = "Default order discovery client";
    static final String CUSTOM_DISCOVERY_CLIENT = "A custom discovery client";
    static final String FOURTH_DISCOVERY_CLIENT = "Fourth discovery client";
    static final String CUSTOM_SERVICE_ID = "custom";

    @Bean
    public DiscoveryClient customDiscoveryClient() {
        return this.aDiscoveryClient(-1, CUSTOM_DISCOVERY_CLIENT);
    }

    @Bean
    public DiscoveryClient thirdOrderCustomDiscoveryClient() {
        return this.aDiscoveryClient(3, FOURTH_DISCOVERY_CLIENT);
    }

    @Bean
    public DiscoveryClient defaultOrderDiscoveryClient() {
        return this.aDiscoveryClient(null, DEFAULT_ORDER_DISCOVERY_CLIENT);
    }

    private DiscoveryClient aDiscoveryClient(final Integer order, final String description) {
        return new DiscoveryClient(){

            public String description() {
                return description;
            }

            public List<ServiceInstance> getInstances(String serviceId) {
                if (serviceId.equals(CompositeDiscoveryClientTestsConfig.CUSTOM_SERVICE_ID)) {
                    DefaultServiceInstance s1 = new DefaultServiceInstance("customInstance", CompositeDiscoveryClientTestsConfig.CUSTOM_SERVICE_ID, "host", 123, false);
                    return Collections.singletonList(s1);
                }
                return Collections.emptyList();
            }

            public List<String> getServices() {
                return Collections.singletonList(CompositeDiscoveryClientTestsConfig.CUSTOM_SERVICE_ID);
            }

            public int getOrder() {
                return order != null ? order.intValue() : super.getOrder();
            }
        };
    }
}

