/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite.reactive;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import reactor.core.publisher.Flux;

class ReactiveCompositeDiscoveryClientAutoConfigurationTests {
    private ApplicationContextRunner contextRunner = (ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{ReactiveCompositeDiscoveryClientAutoConfiguration.class}));

    ReactiveCompositeDiscoveryClientAutoConfigurationTests() {
    }

    @Test
    public void shouldCreateCompositeReactiveDiscoveryClientWithoutDelegates() {
        this.contextRunner.run(context -> {
            ReactiveDiscoveryClient client = (ReactiveDiscoveryClient)context.getBean(ReactiveDiscoveryClient.class);
            Assertions.assertThat((Object)client).isNotNull();
            Assertions.assertThat((Object)client).isInstanceOf(ReactiveCompositeDiscoveryClient.class);
            Assertions.assertThat((List)((ReactiveCompositeDiscoveryClient)client).getDiscoveryClients()).isEmpty();
        });
    }

    @Test
    public void shouldCreateCompositeReactiveDiscoveryClientWithDelegate() {
        ((ApplicationContextRunner)this.contextRunner.withUserConfiguration(new Class[]{Configuration.class})).run(context -> {
            ReactiveDiscoveryClient client = (ReactiveDiscoveryClient)context.getBean(ReactiveDiscoveryClient.class);
            Assertions.assertThat((Object)client).isNotNull();
            Assertions.assertThat((Object)client).isInstanceOf(ReactiveCompositeDiscoveryClient.class);
            Assertions.assertThat((List)((ReactiveCompositeDiscoveryClient)client).getDiscoveryClients()).hasSize(1);
        });
    }

    @TestConfiguration
    static class Configuration {
        Configuration() {
        }

        @Bean
        ReactiveDiscoveryClient discoveryClient() {
            return new ReactiveDiscoveryClient(){

                public String description() {
                    return "Reactive Test Discovery Client";
                }

                public Flux<ServiceInstance> getInstances(String serviceId) {
                    return Flux.empty();
                }

                public Flux<String> getServices() {
                    return Flux.empty();
                }
            };
        }
    }
}

