/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;

public class DiscoveryCompositeHealthContributorTests {
    @Test
    public void createWhenIndicatorsAreNullThrowsException() throws Exception {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new DiscoveryCompositeHealthContributor(null)).withMessage("'indicators' must not be null");
    }

    @Test
    public void getContributorReturnsContributor() throws Exception {
        TestDiscoveryHealthIndicator indicator = new TestDiscoveryHealthIndicator("test", Health.up().build());
        DiscoveryCompositeHealthContributor composite = new DiscoveryCompositeHealthContributor(Arrays.asList(indicator));
        HealthIndicator adapted = (HealthIndicator)composite.getContributor("test");
        Assertions.assertThat((Object)adapted).isNotNull();
        Assertions.assertThat((Object)adapted.health()).isSameAs((Object)indicator.health());
    }

    @Test
    public void getContributorWhenMissingReturnsNull() throws Exception {
        TestDiscoveryHealthIndicator indicator = new TestDiscoveryHealthIndicator("test", Health.up().build());
        DiscoveryCompositeHealthContributor composite = new DiscoveryCompositeHealthContributor(Arrays.asList(indicator));
        Assertions.assertThat((Object)((HealthIndicator)composite.getContributor("missing"))).isNull();
    }

    @Test
    public void iteratorIteratesNamedContributors() throws Exception {
        TestDiscoveryHealthIndicator indicator1 = new TestDiscoveryHealthIndicator("test1", Health.up().build());
        TestDiscoveryHealthIndicator indicator2 = new TestDiscoveryHealthIndicator("test2", Health.down().build());
        DiscoveryCompositeHealthContributor composite = new DiscoveryCompositeHealthContributor(Arrays.asList(indicator1, indicator2));
        ArrayList<NamedContributor> contributors = new ArrayList<NamedContributor>();
        for (NamedContributor contributor : composite) {
            contributors.add(contributor);
        }
        Assertions.assertThat(contributors).hasSize(2);
        Assertions.assertThat(contributors).extracting("name").containsExactlyInAnyOrder(new Object[]{"test1", "test2"});
        Assertions.assertThat(contributors).extracting("contributor").extracting("health").containsExactlyInAnyOrder(new Object[]{indicator1.health(), indicator2.health()});
    }

    private static class TestDiscoveryHealthIndicator
    implements DiscoveryHealthIndicator {
        private final String name;
        private final Health health;

        TestDiscoveryHealthIndicator(String name, Health health) {
            this.name = name;
            this.health = health;
        }

        public String getName() {
            return this.name;
        }

        public Health health() {
            return this.health;
        }
    }
}

