/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health.reactive;

import java.util.Collections;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryHealthIndicator;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

class ReactiveDiscoveryCompositeHealthContributorTests {
    ReactiveDiscoveryCompositeHealthContributorTests() {
    }

    @Test
    void shouldReturnEmptyIterator() {
        ReactiveDiscoveryCompositeHealthContributor healthContributor = new ReactiveDiscoveryCompositeHealthContributor(Collections.emptyList());
        Assertions.assertThat((boolean)healthContributor.iterator().hasNext()).isFalse();
    }

    @Test
    void shouldReturnNullForUnknownContributor() {
        ReactiveDiscoveryCompositeHealthContributor healthContributor = new ReactiveDiscoveryCompositeHealthContributor(Collections.emptyList());
        Assertions.assertThat((Object)healthContributor.getContributor("unknown")).isNull();
    }

    @Test
    void shouldReturnKnownContributor() {
        ReactiveDiscoveryHealthIndicator indicator = (ReactiveDiscoveryHealthIndicator)Mockito.mock(ReactiveDiscoveryHealthIndicator.class);
        Health health = Health.up().build();
        Mockito.when((Object)indicator.getName()).thenReturn((Object)"known");
        Mockito.when((Object)indicator.health()).thenReturn((Object)Mono.just((Object)health));
        ReactiveDiscoveryCompositeHealthContributor healthContributor = new ReactiveDiscoveryCompositeHealthContributor(Collections.singletonList(indicator));
        Assertions.assertThat((Object)healthContributor.getContributor("known")).isNotNull();
        Iterator iterator = healthContributor.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        NamedContributor contributor = (NamedContributor)iterator.next();
        Assertions.assertThat((Object)contributor).isNotNull();
        Assertions.assertThat((String)contributor.getName()).isEqualTo("known");
        Assertions.assertThat((Object)contributor.getContributor()).isNotNull();
        Assertions.assertThat((Object)contributor.getContributor()).isInstanceOf(ReactiveHealthIndicator.class);
        ReactiveHealthIndicator healthIndicator = (ReactiveHealthIndicator)contributor.getContributor();
        StepVerifier.create((Publisher)healthIndicator.getHealth(true)).expectNext((Object)health).expectComplete().verify();
    }
}

