/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.BDDAssertions;
import org.junit.Before;
import org.junit.Test;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;

public class SimpleDiscoveryClientTests {
    private SimpleDiscoveryClient simpleDiscoveryClient;

    @Before
    public void setUp() {
        SimpleDiscoveryProperties simpleDiscoveryProperties = new SimpleDiscoveryProperties();
        HashMap<String, List<SimpleDiscoveryProperties.SimpleServiceInstance>> map = new HashMap<String, List<SimpleDiscoveryProperties.SimpleServiceInstance>>();
        SimpleDiscoveryProperties.SimpleServiceInstance service1Inst1 = new SimpleDiscoveryProperties.SimpleServiceInstance(URI.create("http://host1:8080"));
        SimpleDiscoveryProperties.SimpleServiceInstance service1Inst2 = new SimpleDiscoveryProperties.SimpleServiceInstance(URI.create("https://host2:8443"));
        map.put("service1", Arrays.asList(service1Inst1, service1Inst2));
        simpleDiscoveryProperties.setInstances(map);
        simpleDiscoveryProperties.init();
        this.simpleDiscoveryClient = new SimpleDiscoveryClient(simpleDiscoveryProperties);
    }

    @Test
    public void shouldBeAbleToRetrieveServiceDetailsByName() {
        List instances = this.simpleDiscoveryClient.getInstances("service1");
        BDDAssertions.then((int)instances.size()).isEqualTo(2);
        BDDAssertions.then((String)((ServiceInstance)instances.get(0)).getServiceId()).isEqualTo("service1");
        BDDAssertions.then((String)((ServiceInstance)instances.get(0)).getHost()).isEqualTo("host1");
        BDDAssertions.then((int)((ServiceInstance)instances.get(0)).getPort()).isEqualTo(8080);
        BDDAssertions.then((URI)((ServiceInstance)instances.get(0)).getUri()).isEqualTo((Object)URI.create("http://host1:8080"));
        BDDAssertions.then((boolean)((ServiceInstance)instances.get(0)).isSecure()).isEqualTo(false);
        BDDAssertions.then((Map)((ServiceInstance)instances.get(0)).getMetadata()).isNotNull();
    }
}

