/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.hypermedia.CloudHypermediaAutoConfiguration;
import org.springframework.cloud.client.hypermedia.DiscoveredResource;
import org.springframework.cloud.client.hypermedia.RemoteResource;
import org.springframework.cloud.client.hypermedia.RemoteResourceRefresher;
import org.springframework.cloud.client.hypermedia.ServiceInstanceProvider;
import org.springframework.cloud.client.hypermedia.StaticServiceInstanceProvider;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class CloudHypermediaAutoConfigurationIntegrationTests {
    private static ConfigurableApplicationContext getApplicationContext(Class<?> configuration) {
        return new SpringApplicationBuilder(new Class[]{configuration}).properties(new String[]{"server.port=0"}).run(new String[0]);
    }

    @Test
    public void picksUpHypermediaProperties() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(ConfigWithRemoteResource.class);){
            CloudHypermediaAutoConfiguration.CloudHypermediaProperties properties = (CloudHypermediaAutoConfiguration.CloudHypermediaProperties)context.getBean(CloudHypermediaAutoConfiguration.CloudHypermediaProperties.class);
            BDDAssertions.then((int)properties.getRefresh().getInitialDelay()).isEqualTo(50000);
            BDDAssertions.then((int)properties.getRefresh().getFixedDelay()).isEqualTo(10000);
        }
    }

    @Test
    public void doesNotCreateCloudHypermediaPropertiesifNotActive() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(Config.class);){
            BDDAssertions.then((Object[])context.getBeanNamesForType(CloudHypermediaAutoConfiguration.CloudHypermediaProperties.class)).hasSize(0);
        }
    }

    @Test
    public void doesNotRegisterResourceRefresherIfNoDiscoveredResourceIsDefined() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(Config.class);){
            BDDAssertions.then(context.getBeansOfType(RemoteResource.class).values()).hasSize(0);
            BDDAssertions.then((Object[])context.getBeanNamesForType(RemoteResourceRefresher.class)).hasSize(0);
        }
    }

    @Test
    public void registersResourceRefresherIfDiscoverredResourceIsDefined() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(ConfigWithRemoteResource.class);){
            BDDAssertions.then(context.getBeansOfType(RemoteResource.class).values()).hasSize(1);
            BDDAssertions.then((Object)context.getBean(RemoteResourceRefresher.class)).isNotNull();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    static class ConfigWithRemoteResource {
        ConfigWithRemoteResource() {
        }

        @Bean
        public RemoteResource resource() {
            StaticServiceInstanceProvider provider = new StaticServiceInstanceProvider((ServiceInstance)new DefaultServiceInstance("instance", "service", "localhost", 80, false));
            return new DiscoveredResource((ServiceInstanceProvider)provider, traverson -> traverson.follow(new String[]{"rel"}));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    static class Config {
        Config() {
        }
    }
}

