/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.util.Arrays;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.hypermedia.DynamicServiceInstanceProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class DynamicServiceInstanceProviderUnitTests {
    @Mock
    DiscoveryClient client;

    @Test
    public void returnsNoServiceInCaseNoneIsAvailable() {
        BDDAssertions.then((Object)new DynamicServiceInstanceProvider(this.client, "service").getServiceInstance()).isNull();
    }

    @Test
    public void returnsFirstServiceInCaseMultipleOnesAreAvailable() {
        ServiceInstance first = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        ServiceInstance second = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.getInstances(Matchers.anyString())).thenReturn(Arrays.asList(first, second));
        BDDAssertions.then((Object)new DynamicServiceInstanceProvider(this.client, "service").getServiceInstance()).isEqualTo((Object)first);
    }
}

