/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.web.client.AsyncRestTemplate;

public class AsyncLoadBalancerAutoConfigurationTests {
    @Test
    public void restTemplateGetsLoadBalancerInterceptor() {
        ConfigurableApplicationContext context = this.init(OneRestTemplate.class);
        Map restTemplates = context.getBeansOfType(AsyncRestTemplate.class);
        BDDAssertions.then((Map)restTemplates).isNotNull();
        BDDAssertions.then(restTemplates.values()).hasSize(1);
        AsyncRestTemplate restTemplate = (AsyncRestTemplate)restTemplates.values().iterator().next();
        BDDAssertions.then((Object)restTemplate).isNotNull();
        this.assertLoadBalanced(restTemplate);
    }

    private void assertLoadBalanced(AsyncRestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        BDDAssertions.then((List)interceptors).hasSize(1);
        AsyncClientHttpRequestInterceptor interceptor = (AsyncClientHttpRequestInterceptor)interceptors.get(0);
        BDDAssertions.then((Object)interceptor).isInstanceOf(AsyncLoadBalancerInterceptor.class);
    }

    @Test
    public void multipleRestTemplates() {
        ConfigurableApplicationContext context = this.init(TwoRestTemplates.class);
        Map restTemplates = context.getBeansOfType(AsyncRestTemplate.class);
        BDDAssertions.then((Map)restTemplates).isNotNull();
        Collection templates = restTemplates.values();
        BDDAssertions.then(templates).hasSize(2);
        TwoRestTemplates.Two two = (TwoRestTemplates.Two)context.getBean(TwoRestTemplates.Two.class);
        BDDAssertions.then((Object)two.loadBalanced).isNotNull();
        this.assertLoadBalanced(two.loadBalanced);
        BDDAssertions.then((Object)two.nonLoadBalanced).isNotNull();
        BDDAssertions.then((List)two.nonLoadBalanced.getInterceptors()).isEmpty();
    }

    protected ConfigurableApplicationContext init(Class<?> config) {
        return new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.NONE).properties(new String[]{"spring.aop.proxyTargetClass=true"}).sources(new Class[]{config, AsyncLoadBalancerAutoConfiguration.class}).run(new String[0]);
    }

    private static class NoopLoadBalancerClient
    implements LoadBalancerClient {
        private final Random random = new Random();

        private NoopLoadBalancerClient() {
        }

        public ServiceInstance choose(String serviceId) {
            return new DefaultServiceInstance(serviceId, serviceId, serviceId, this.random.nextInt(40000), false);
        }

        public <T> T execute(String serviceId, LoadBalancerRequest<T> request) {
            try {
                return (T)request.apply(this.choose(serviceId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
            try {
                return (T)request.apply(this.choose(serviceId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public URI reconstructURI(ServiceInstance instance, URI original) {
            return DefaultServiceInstance.getUri((ServiceInstance)instance);
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class TwoRestTemplates {
        protected TwoRestTemplates() {
        }

        @Primary
        @Bean
        AsyncRestTemplate restTemplate() {
            return new AsyncRestTemplate();
        }

        @LoadBalanced
        @Bean
        AsyncRestTemplate loadBalancedRestTemplate() {
            return new AsyncRestTemplate();
        }

        @Bean
        LoadBalancerClient loadBalancerClient() {
            return new NoopLoadBalancerClient();
        }

        @Configuration(proxyBeanMethods=false)
        protected static class Two {
            @Autowired
            AsyncRestTemplate nonLoadBalanced;
            @Autowired
            @LoadBalanced
            AsyncRestTemplate loadBalanced;

            protected Two() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class OneRestTemplate {
        protected OneRestTemplate() {
        }

        @LoadBalanced
        @Bean
        AsyncRestTemplate loadBalancedRestTemplate() {
            return new AsyncRestTemplate();
        }

        @Bean
        LoadBalancerClient loadBalancerClient() {
            return new NoopLoadBalancerClient();
        }

        @Bean
        LoadBalancedRetryFactory loadBalancedRetryFactory() {
            return new LoadBalancedRetryFactory(){};
        }
    }
}

