/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.cloud.client.loadbalancer.ClientHttpResponseStatusCodeException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientHttpResponseStatusCodeExceptionTest {
    @Test
    public void testCreation() throws Exception {
        MyClientHttpResponse response = new MyClientHttpResponse();
        BDDAssertions.then((boolean)response.isClosed()).isFalse();
        ClientHttpResponseStatusCodeException exp = new ClientHttpResponseStatusCodeException("service", (ClientHttpResponse)response, response.getStatusText().getBytes());
        ClientHttpResponse expResponse = exp.getResponse();
        BDDAssertions.then((int)expResponse.getRawStatusCode()).isEqualTo(response.getRawStatusCode());
        BDDAssertions.then((String)expResponse.getStatusText()).isEqualTo(response.getStatusText());
        BDDAssertions.then((Map)expResponse.getHeaders()).isEqualTo((Object)response.getHeaders());
        BDDAssertions.then((String)new String(StreamUtils.copyToByteArray((InputStream)expResponse.getBody()))).isEqualTo(response.getStatusText());
    }

    class MyClientHttpResponse
    extends AbstractClientHttpResponse {
        private boolean closed = false;

        MyClientHttpResponse() {
        }

        public int getRawStatusCode() throws IOException {
            return 200;
        }

        public String getStatusText() throws IOException {
            return "foo";
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public InputStream getBody() throws IOException {
            return new ByteArrayInputStream(this.getStatusText().getBytes());
        }

        public HttpHeaders getHeaders() {
            HttpHeaders headers = new HttpHeaders();
            headers.add("foo", "bar");
            return headers;
        }
    }
}

