/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.assertj.core.api.BDDAssertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RetryContext;

@RunWith(value=MockitoJUnitRunner.class)
public class InterceptorRetryPolicyTest {
    private HttpRequest request;
    private LoadBalancedRetryPolicy policy;
    private ServiceInstanceChooser serviceInstanceChooser;
    private String serviceName;

    @Before
    public void setup() {
        this.request = (HttpRequest)Mockito.mock(HttpRequest.class);
        this.policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        this.serviceInstanceChooser = (ServiceInstanceChooser)Mockito.mock(ServiceInstanceChooser.class);
        this.serviceName = "foo";
    }

    @After
    public void teardown() {
        this.request = null;
        this.policy = null;
        this.serviceInstanceChooser = null;
        this.serviceName = null;
    }

    @Test
    public void canRetryBeforeExecution() throws Exception {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Mockito.when((Object)context.getRetryCount()).thenReturn((Object)0);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.serviceInstanceChooser.choose((String)Matchers.eq((Object)this.serviceName))).thenReturn((Object)serviceInstance);
        BDDAssertions.then((boolean)interceptorRetryPolicy.canRetry((RetryContext)context)).isTrue();
        ((LoadBalancedRetryContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).setServiceInstance((ServiceInstance)Matchers.eq((Object)serviceInstance));
    }

    @Test
    public void canRetryNextServer() throws Exception {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Mockito.when((Object)context.getRetryCount()).thenReturn((Object)1);
        Mockito.when((Object)this.policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.eq((Object)context))).thenReturn((Object)true);
        BDDAssertions.then((boolean)interceptorRetryPolicy.canRetry((RetryContext)context)).isTrue();
    }

    @Test
    public void cannotRetry() throws Exception {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Mockito.when((Object)context.getRetryCount()).thenReturn((Object)1);
        BDDAssertions.then((boolean)interceptorRetryPolicy.canRetry((RetryContext)context)).isFalse();
    }

    @Test
    public void open() throws Exception {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        RetryContext context = interceptorRetryPolicy.open(null);
        BDDAssertions.then((Object)context).isInstanceOf(LoadBalancedRetryContext.class);
    }

    @Test
    public void close() throws Exception {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        interceptorRetryPolicy.close((RetryContext)context);
        ((LoadBalancedRetryPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)1))).close((LoadBalancedRetryContext)Matchers.eq((Object)context));
    }

    @Test
    public void registerThrowable() throws Exception {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Exception thrown = new Exception();
        interceptorRetryPolicy.registerThrowable((RetryContext)context, (Throwable)thrown);
        ((LoadBalancedRetryContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).registerThrowable((Throwable)Matchers.eq((Object)thrown));
        ((LoadBalancedRetryPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)1))).registerThrowable((LoadBalancedRetryContext)Matchers.eq((Object)context), (Throwable)Matchers.eq((Object)thrown));
    }

    @Test
    public void equals() throws Exception {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals(null)).isFalse();
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals(new Object())).isFalse();
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals((Object)interceptorRetryPolicy)).isTrue();
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals((Object)new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName))).isTrue();
    }
}

