/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.runner.RunWith;
import org.springframework.cloud.client.loadbalancer.AbstractLoadBalancerAutoConfigurationTests;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.test.ClassPathExclusions;
import org.springframework.cloud.test.ModifiedClassPathRunner;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@RunWith(value=ModifiedClassPathRunner.class)
@ClassPathExclusions(value={"spring-retry-*.jar", "spring-boot-starter-aop-*.jar"})
public class LoadBalancerAutoConfigurationTests
extends AbstractLoadBalancerAutoConfigurationTests {
    @Override
    protected void assertLoadBalanced(RestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        BDDAssertions.then((List)interceptors).hasSize(1);
        ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)interceptors.get(0);
        BDDAssertions.then((Object)interceptor).isInstanceOf(LoadBalancerInterceptor.class);
    }
}

