/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.TestServiceInstance;
import org.springframework.web.util.UriComponentsBuilder;

class LoadBalancerUriToolsTests {
    LoadBalancerUriToolsTests() {
    }

    @Test
    void originalURIReturnedIfDataMatches() {
        TestServiceInstance serviceInstance = new TestServiceInstance();
        URI original = UriComponentsBuilder.fromUriString((String)"http://test.example:8080/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isEqualTo((Object)original);
    }

    @Test
    void serviceInstanceHostSet() {
        TestServiceInstance serviceInstance = new TestServiceInstance();
        URI original = UriComponentsBuilder.fromUriString((String)"http://testHost.example:8080/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getHost()).isEqualTo(serviceInstance.getHost());
    }

    @Test
    void serviceInstanceSchemeSet() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withScheme("https");
        URI original = UriComponentsBuilder.fromUriString((String)"http://test.example/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getScheme()).isEqualTo(serviceInstance.getScheme());
    }

    @Test
    void originalSchemeSetIfServiceInstanceSchemeMissing() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withScheme(null);
        URI original = UriComponentsBuilder.fromUriString((String)"https://test.example/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getScheme()).isEqualTo(original.getScheme());
    }

    @Test
    void secureSchemeSetIfServiceInstanceSchemeMissingAndServiceInstanceSecure() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withScheme(null).withSecure(true);
        URI original = UriComponentsBuilder.fromUriString((String)"http://test.example/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getScheme()).isEqualTo("https");
    }

    @Test
    void secureWsSchemeSetIfServiceInstanceSchemeMissingAndServiceInstanceSecure() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withScheme(null).withSecure(true);
        URI original = UriComponentsBuilder.fromUriString((String)"ws://test.example/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getScheme()).isEqualTo("wss");
    }

    @Test
    void defaultSchemeSetIfMissing() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withScheme(null);
        URI original = UriComponentsBuilder.fromUriString((String)"//test.example/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getScheme()).isEqualTo("http");
    }

    @Test
    void serviceInstancePortSet() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withPort(0);
        URI original = UriComponentsBuilder.fromUriString((String)"http://test.example:8080/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((int)reconstructed.getPort()).isEqualTo(serviceInstance.getPort());
    }

    @Test
    void defaultHttpPortSetIfServiceInstancePortIncorrect() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withPort(-1);
        URI original = UriComponentsBuilder.fromUriString((String)"http://test.example:8888/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((int)reconstructed.getPort()).isEqualTo(80);
    }

    @Test
    void defaultHttpsPortSetIfServiceInstancePortIncorrect() {
        TestServiceInstance serviceInstance = new TestServiceInstance().withScheme("https").withPort(-1);
        URI original = UriComponentsBuilder.fromUriString((String)"http://test.example:8888/xxx").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((int)reconstructed.getPort()).isEqualTo(443);
    }

    @Test
    void originalUserInfoSet() {
        TestServiceInstance serviceInstance = new TestServiceInstance();
        URI original = UriComponentsBuilder.fromUriString((String)"http://testUser@testHost.example/path?query1=test1&query2=test2#fragment").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getRawUserInfo()).isEqualTo(original.getRawUserInfo());
        Assertions.assertThat((String)reconstructed.getRawQuery()).isEqualTo(original.getRawQuery());
        Assertions.assertThat((String)reconstructed.getRawPath()).isEqualTo(original.getRawPath());
        Assertions.assertThat((String)reconstructed.getRawQuery()).isEqualTo(original.getRawQuery());
        Assertions.assertThat((String)reconstructed.getRawFragment()).isEqualTo(original.getRawFragment());
        Assertions.assertThat((String)reconstructed.getHost()).isEqualTo(serviceInstance.getHost());
        Assertions.assertThat((int)reconstructed.getPort()).isEqualTo(serviceInstance.getPort());
    }

    @Test
    void reconstructedURIEncodedCorrectly() {
        TestServiceInstance serviceInstance = new TestServiceInstance();
        URI original = UriComponentsBuilder.fromUriString((String)"http://test.example/path%40%21%242?query=val%40%21%242#frag%40%21%242").build().toUri();
        URI reconstructed = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
        Assertions.assertThat((URI)reconstructed).isNotNull();
        Assertions.assertThat((String)reconstructed.getRawUserInfo()).isEqualTo(original.getRawUserInfo());
        Assertions.assertThat((String)reconstructed.getRawQuery()).isEqualTo(original.getRawQuery());
        Assertions.assertThat((String)reconstructed.getRawPath()).isEqualTo(original.getRawPath());
        Assertions.assertThat((String)reconstructed.getRawQuery()).isEqualTo(original.getRawQuery());
        Assertions.assertThat((String)reconstructed.getRawFragment()).isEqualTo(original.getRawFragment());
        Assertions.assertThat((String)reconstructed.getHost()).isEqualTo(serviceInstance.getHost());
        Assertions.assertThat((int)reconstructed.getPort()).isEqualTo(serviceInstance.getPort());
    }
}

