/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.cloud.client.loadbalancer.AbstractLoadBalancerAutoConfigurationTests;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.web.client.RestTemplate;

public class RetryLoadBalancerAutoConfigurationTests
extends AbstractLoadBalancerAutoConfigurationTests {
    @Override
    protected void assertLoadBalanced(RestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        BDDAssertions.then((List)interceptors).hasSize(1);
        ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)interceptors.get(0);
        BDDAssertions.then((Object)interceptor).isInstanceOf(RetryLoadBalancerInterceptor.class);
    }

    @Test
    public void testDefaultBackOffPolicy() throws Exception {
        ConfigurableApplicationContext context = this.init(AbstractLoadBalancerAutoConfigurationTests.OneRestTemplate.class);
        LoadBalancedRetryFactory loadBalancedRetryFactory = (LoadBalancedRetryFactory)context.getBean(LoadBalancedRetryFactory.class);
        BDDAssertions.then((Object)loadBalancedRetryFactory).isInstanceOf(LoadBalancedRetryFactory.class);
        BDDAssertions.then((Object)loadBalancedRetryFactory.createBackOffPolicy("foo")).isInstanceOf(NoBackOffPolicy.class);
    }
}

