/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.assertj.core.api.BDDAssertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.TerminatedRetryException;
import org.springframework.retry.backoff.BackOffContext;
import org.springframework.retry.backoff.BackOffInterruptedException;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.listener.RetryListenerSupport;

@RunWith(value=MockitoJUnitRunner.class)
public class RetryLoadBalancerInterceptorTest {
    private LoadBalancerClient client;
    private LoadBalancerRetryProperties lbProperties;
    private LoadBalancerRequestFactory lbRequestFactory;
    private LoadBalancedRetryFactory loadBalancedRetryFactory = new LoadBalancedRetryFactory(){};

    @Before
    public void setUp() throws Exception {
        this.client = (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        this.lbProperties = new LoadBalancerRetryProperties();
        this.lbRequestFactory = (LoadBalancerRequestFactory)Mockito.mock(LoadBalancerRequestFactory.class);
    }

    @After
    public void tearDown() throws Exception {
        this.client = null;
        this.lbProperties = null;
    }

    @Test(expected=IOException.class)
    public void interceptDisableRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()});
        this.lbProperties.setEnabled(false);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, this.loadBalancedRetryFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)Matchers.any(), (byte[])Matchers.any(), (ClientHttpRequestExecution)Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test(expected=IllegalStateException.class)
    public void interceptInvalidHost() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo_underscore"));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, this.loadBalancedRetryFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
    }

    @Test
    public void interceptNeverRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)Matchers.any(), (byte[])Matchers.any(), (ClientHttpRequestExecution)Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, this.loadBalancedRetryFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptSuccess() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)Matchers.any(), (byte[])Matchers.any(), (ClientHttpRequestExecution)Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy));
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetryOnStatusCode() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        InputStream notFoundStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)notFoundStream.read((byte[])Matchers.any(byte[].class))).thenReturn((Object)-1);
        MockClientHttpResponse clientHttpResponseNotFound = new MockClientHttpResponse(notFoundStream, HttpStatus.NOT_FOUND);
        MockClientHttpResponse clientHttpResponseOk = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.retryableStatusCode(Matchers.eq((int)HttpStatus.NOT_FOUND.value()))).thenReturn((Object)true);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.nullable(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponseNotFound).thenReturn((Object)clientHttpResponseOk);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy));
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.nullable(LoadBalancerRequest.class));
        ((InputStream)Mockito.verify((Object)notFoundStream, (VerificationMode)Mockito.times((int)1))).close();
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponseOk);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetryFailOnStatusCode() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        ByteArrayInputStream notFoundStream = new ByteArrayInputStream("foo".getBytes());
        MockClientHttpResponse clientHttpResponseNotFound = new MockClientHttpResponse((InputStream)notFoundStream, HttpStatus.NOT_FOUND);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.retryableStatusCode(Matchers.eq((int)HttpStatus.NOT_FOUND.value()))).thenReturn((Object)true);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any())).thenReturn((Object)clientHttpResponseNotFound);
        this.lbProperties.setEnabled(true);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy));
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any());
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)1))).createRequest(request, body, execution);
        ((LoadBalancedRetryPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.times((int)2))).canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class));
        byte[] content = new byte[1024];
        int length = rsp.getBody().read(content);
        BDDAssertions.then((int)length).isEqualTo("foo".getBytes().length);
        BDDAssertions.then((String)new String(content, 0, length)).isEqualTo("foo");
    }

    @Test
    public void interceptRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)Matchers.any(), (byte[])Matchers.any(), (ClientHttpRequestExecution)Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy));
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        BDDAssertions.then((int)backOffPolicy.getBackoffAttempts()).isEqualTo(1);
    }

    @Test(expected=IOException.class)
    public void interceptFailedRetry() throws Exception {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)Matchers.any(), (byte[])Matchers.any(), (ClientHttpRequestExecution)Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy));
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void retryListenerTest() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://listener"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"listener"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"listener"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        MyRetryListener retryListener = new MyRetryListener();
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)Matchers.any(), (byte[])Matchers.any(), (ClientHttpRequestExecution)Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy, new RetryListener[]{retryListener}));
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"listener"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        BDDAssertions.then((int)backOffPolicy.getBackoffAttempts()).isEqualTo(1);
        BDDAssertions.then((int)retryListener.getOnError()).isEqualTo(1);
    }

    @Test(expected=TerminatedRetryException.class)
    public void retryListenerTestNoRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://noRetry"));
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        this.lbProperties.setEnabled(true);
        RetryListenerSupport myRetryListener = new RetryListenerSupport(){

            public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
                return false;
            }
        };
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy, new RetryListener[]{myRetryListener}));
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, new byte[0], execution);
    }

    @Test
    public void retryWithDefaultConstructorTest() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://default"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"default"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"default"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)Matchers.any(), (byte[])Matchers.any(), (ClientHttpRequestExecution)Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy));
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"default"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        BDDAssertions.then((int)backOffPolicy.getBackoffAttempts()).isEqualTo(1);
    }

    class MyRetryListener
    extends RetryListenerSupport {
        private int onError = 0;

        MyRetryListener() {
        }

        public <T, E extends Throwable> void onError(RetryContext retryContext, RetryCallback<T, E> retryCallback, Throwable throwable) {
            ++this.onError;
        }

        int getOnError() {
            return this.onError;
        }
    }

    class MyBackOffPolicy
    implements BackOffPolicy {
        private int backoffAttempts = 0;

        MyBackOffPolicy() {
        }

        public BackOffContext start(RetryContext retryContext) {
            return new BackOffContext(){

                protected Object clone() throws CloneNotSupportedException {
                    return super.clone();
                }
            };
        }

        public void backOff(BackOffContext backOffContext) throws BackOffInterruptedException {
            ++this.backoffAttempts;
        }

        int getBackoffAttempts() {
            return this.backoffAttempts;
        }
    }

    class MyLoadBalancedRetryFactory
    implements LoadBalancedRetryFactory {
        private LoadBalancedRetryPolicy loadBalancedRetryPolicy;
        private BackOffPolicy backOffPolicy;
        private RetryListener[] retryListeners;

        MyLoadBalancedRetryFactory(LoadBalancedRetryPolicy loadBalancedRetryPolicy) {
            this.loadBalancedRetryPolicy = loadBalancedRetryPolicy;
        }

        MyLoadBalancedRetryFactory(LoadBalancedRetryPolicy loadBalancedRetryPolicy, BackOffPolicy backOffPolicy) {
            this(loadBalancedRetryPolicy);
            this.backOffPolicy = backOffPolicy;
        }

        MyLoadBalancedRetryFactory(LoadBalancedRetryPolicy loadBalancedRetryPolicy, BackOffPolicy backOffPolicy, RetryListener[] retryListeners) {
            this(loadBalancedRetryPolicy, backOffPolicy);
            this.retryListeners = retryListeners;
        }

        public LoadBalancedRetryPolicy createRetryPolicy(String service, ServiceInstanceChooser serviceInstanceChooser) {
            return this.loadBalancedRetryPolicy;
        }

        public BackOffPolicy createBackOffPolicy(String service) {
            if (this.backOffPolicy == null) {
                return new NoBackOffPolicy();
            }
            return this.backOffPolicy;
        }

        public RetryListener[] createRetryListeners(String service) {
            if (this.retryListeners == null) {
                return new RetryListener[0];
            }
            return this.retryListeners;
        }
    }
}

