/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.util.List;
import java.util.Random;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.reactive.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.reactive.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.Request;
import org.springframework.cloud.client.loadbalancer.reactive.Response;
import reactor.core.publisher.Mono;

class DiscoveryClientBasedReactiveLoadBalancer
implements ReactiveLoadBalancer<ServiceInstance> {
    private final Random random = new Random();
    private final String serviceId;
    private final DiscoveryClient discoveryClient;

    DiscoveryClientBasedReactiveLoadBalancer(String serviceId, DiscoveryClient discoveryClient) {
        this.serviceId = serviceId;
        this.discoveryClient = discoveryClient;
    }

    public Publisher<Response<ServiceInstance>> choose() {
        List instances = this.discoveryClient.getInstances(this.serviceId);
        if (instances.size() == 0) {
            return Mono.just((Object)new EmptyResponse());
        }
        int instanceIdx = this.random.nextInt(instances.size());
        return Mono.just((Object)new DefaultResponse((ServiceInstance)instances.get(instanceIdx)));
    }

    public Publisher<Response<ServiceInstance>> choose(Request request) {
        return this.choose();
    }
}

