/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.assertj.core.api.BDDAssertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class LoadBalancerExchangeFilterFunctionTests {
    @Autowired
    private LoadBalancerExchangeFilterFunction lbFunction;
    @Autowired
    private SimpleDiscoveryProperties properties;
    @LocalServerPort
    private int port;

    @Before
    public void before() {
        SimpleDiscoveryProperties.SimpleServiceInstance instance = new SimpleDiscoveryProperties.SimpleServiceInstance();
        instance.setServiceId("testservice");
        instance.setUri(URI.create("http://localhost:" + this.port));
        this.properties.getInstances().put("testservice", Arrays.asList(instance));
    }

    @Test
    public void testFilterFunctionWorks() {
        String value = (String)WebClient.builder().baseUrl("http://testservice").filter((ExchangeFilterFunction)this.lbFunction).build().get().uri("/hello", new Object[0]).retrieve().bodyToMono(String.class).block();
        BDDAssertions.then((String)value).isEqualTo("Hello World");
    }

    @Test
    public void testNoInstance() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://foobar").filter((ExchangeFilterFunction)this.lbFunction).build().get().exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.SERVICE_UNAVAILABLE);
    }

    @Test
    public void testNoHostName() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http:///foobar").filter((ExchangeFilterFunction)this.lbFunction).build().get().exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.BAD_REQUEST);
    }

    @EnableDiscoveryClient
    @EnableAutoConfiguration
    @SpringBootConfiguration
    @RestController
    static class Config {
        Config() {
        }

        @RequestMapping(value={"/hello"})
        public String hello() {
            return "Hello World";
        }

        @Bean
        LoadBalancerClient loadBalancerClient(final DiscoveryClient discoveryClient) {
            return new LoadBalancerClient(){
                Random random = new Random();

                public <T> T execute(String serviceId, LoadBalancerRequest<T> request) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public URI reconstructURI(ServiceInstance instance, URI original) {
                    return UriComponentsBuilder.fromUri((URI)original).host(instance.getHost()).port(instance.getPort()).build().toUri();
                }

                public ServiceInstance choose(String serviceId) {
                    List instances = discoveryClient.getInstances(serviceId);
                    if (instances.size() == 0) {
                        return null;
                    }
                    int instanceIdx = this.random.nextInt(instances.size());
                    return (ServiceInstance)instances.get(instanceIdx);
                }
            };
        }
    }
}

