/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.util.Map;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerBeanPostProcessorAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerTestUtils;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.TestReactiveLoadBalancer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.reactive.function.client.WebClient;

public class ReactorLoadBalancerClientAutoConfigurationTests {
    @Test
    void loadBalancerFilterAddedToWebClientBuilder() {
        ConfigurableApplicationContext context = this.init(OneWebClientBuilder.class);
        Map webClientBuilders = context.getBeansOfType(WebClient.Builder.class);
        ((MapAssert)BDDAssertions.then((Map)webClientBuilders).isNotNull()).hasSize(1);
        WebClient.Builder webClientBuilder = (WebClient.Builder)webClientBuilders.values().iterator().next();
        BDDAssertions.then((Object)webClientBuilder).isNotNull();
        LoadBalancerTestUtils.assertLoadBalanced(webClientBuilder, ReactorLoadBalancerExchangeFilterFunction.class);
        Map testServiceMap = context.getBeansOfType(OneWebClientBuilder.TestService.class);
        ((MapAssert)BDDAssertions.then((Map)testServiceMap).isNotNull()).hasSize(1);
        OneWebClientBuilder.TestService testService = (OneWebClientBuilder.TestService)testServiceMap.values().stream().findFirst().get();
        LoadBalancerTestUtils.assertLoadBalanced(testService.webClient, ReactorLoadBalancerExchangeFilterFunction.class);
    }

    @Test
    void loadBalancerFilterAddedOnlyToLoadBalancedWebClientBuilder() {
        ConfigurableApplicationContext context = this.init(TwoWebClientBuilders.class);
        Map webClientBuilders = context.getBeansOfType(WebClient.Builder.class);
        BDDAssertions.then((Map)webClientBuilders).hasSize(2);
        TwoWebClientBuilders.Two two = (TwoWebClientBuilders.Two)context.getBean(TwoWebClientBuilders.Two.class);
        BDDAssertions.then((Object)two.loadBalanced).isNotNull();
        LoadBalancerTestUtils.assertLoadBalanced(two.loadBalanced, ReactorLoadBalancerExchangeFilterFunction.class);
        BDDAssertions.then((Object)two.nonLoadBalanced).isNotNull();
        BDDAssertions.then(LoadBalancerTestUtils.getFilters(two.nonLoadBalanced)).isNullOrEmpty();
    }

    @Test
    void noCustomWebClientBuilders() {
        ConfigurableApplicationContext context = this.init(NoWebClientBuilder.class);
        Map webClientBuilders = context.getBeansOfType(WebClient.Builder.class);
        BDDAssertions.then((Map)webClientBuilders).hasSize(1);
        WebClient.Builder builder = (WebClient.Builder)context.getBean(WebClient.Builder.class);
        BDDAssertions.then((Object)builder).isNotNull();
        BDDAssertions.then(LoadBalancerTestUtils.getFilters(builder)).isNullOrEmpty();
    }

    private ConfigurableApplicationContext init(Class<?> config) {
        return LoadBalancerTestUtils.init(config, ReactorLoadBalancerClientAutoConfiguration.class, LoadBalancerBeanPostProcessorAutoConfiguration.class);
    }

    @Configuration
    protected static class TwoWebClientBuilders
    extends OneWebClientBuilder {
        protected TwoWebClientBuilders() {
        }

        @Primary
        @Bean
        WebClient.Builder webClientBuilder() {
            return WebClient.builder();
        }

        @Configuration
        protected static class Two {
            @Autowired
            WebClient.Builder nonLoadBalanced;
            @Autowired
            @LoadBalanced
            WebClient.Builder loadBalanced;

            protected Two() {
            }
        }
    }

    @Configuration
    protected static class OneWebClientBuilder
    extends NoWebClientBuilder {
        protected OneWebClientBuilder() {
        }

        @Bean
        @LoadBalanced
        WebClient.Builder loadBalancedWebClientBuilder() {
            return WebClient.builder();
        }

        @Bean
        TestService testService() {
            return new TestService(this.loadBalancedWebClientBuilder());
        }

        private final class TestService {
            public final WebClient webClient;

            private TestService(WebClient.Builder builder) {
                this.webClient = builder.build();
            }
        }
    }

    @Configuration
    protected static class NoWebClientBuilder {
        protected NoWebClientBuilder() {
        }

        @Bean
        ReactiveLoadBalancer.Factory<ServiceInstance> reactiveLoadBalancerFactory() {
            return serviceId -> new TestReactiveLoadBalancer();
        }

        @Bean
        LoadBalancedRetryFactory loadBalancedRetryFactory() {
            return new LoadBalancedRetryFactory(){};
        }
    }
}

