/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import java.util.Collections;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.cloud.client.loadbalancer.reactive.DiscoveryClientBasedReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
class ReactorLoadBalancerExchangeFilterFunctionTests {
    @Autowired
    private ReactorLoadBalancerExchangeFilterFunction loadBalancerFunction;
    @Autowired
    private SimpleDiscoveryProperties properties;
    @LocalServerPort
    private int port;

    ReactorLoadBalancerExchangeFilterFunctionTests() {
    }

    @BeforeEach
    void setUp() {
        SimpleDiscoveryProperties.SimpleServiceInstance instance = new SimpleDiscoveryProperties.SimpleServiceInstance();
        instance.setServiceId("testservice");
        instance.setUri(URI.create("http://localhost:" + this.port));
        this.properties.getInstances().put("testservice", Collections.singletonList(instance));
    }

    @Test
    void correctResponseReturnedForExistingHostAndInstancePresent() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://testservice").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().uri("/hello", new Object[0]).exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.OK);
        BDDAssertions.then((String)((String)clientResponse.bodyToMono(String.class).block())).isEqualTo("Hello World");
    }

    @Test
    void serviceUnavailableReturnedWhenNoInstancePresent() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://xxx").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.SERVICE_UNAVAILABLE);
    }

    @Test
    void badRequestReturnedForIncorrectHost() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http:///xxx").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.BAD_REQUEST);
    }

    @EnableDiscoveryClient
    @EnableAutoConfiguration
    @SpringBootConfiguration
    @RestController
    static class Config {
        Config() {
        }

        @RequestMapping(value={"/hello"})
        public String hello() {
            return "Hello World";
        }

        @Bean
        ReactiveLoadBalancer.Factory<ServiceInstance> reactiveLoadBalancerFactory(DiscoveryClient discoveryClient) {
            return serviceId -> new DiscoveryClientBasedReactiveLoadBalancer(serviceId, discoveryClient);
        }
    }
}

