/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.config.Lookup;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultApacheHttpClientConnectionManagerFactoryTests {
    @Test
    public void newConnectionManager() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6);
        BDDAssertions.then((int)((PoolingHttpClientConnectionManager)connectionManager).getDefaultMaxPerRoute()).isEqualTo(6);
        BDDAssertions.then((int)((PoolingHttpClientConnectionManager)connectionManager).getMaxTotal()).isEqualTo(2);
        Object pool = this.getField((PoolingHttpClientConnectionManager)connectionManager, "pool");
        BDDAssertions.then((Long)((Long)this.getField(pool, "timeToLive"))).isEqualTo((Object)new Long(-1L));
        TimeUnit timeUnit = (TimeUnit)((Object)this.getField(pool, "tunit"));
        BDDAssertions.then((Comparable)((Object)timeUnit)).isEqualTo((Object)TimeUnit.MILLISECONDS);
    }

    @Test
    public void newConnectionManagerWithTTL() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6, 56L, TimeUnit.DAYS, null);
        BDDAssertions.then((int)((PoolingHttpClientConnectionManager)connectionManager).getDefaultMaxPerRoute()).isEqualTo(6);
        BDDAssertions.then((int)((PoolingHttpClientConnectionManager)connectionManager).getMaxTotal()).isEqualTo(2);
        Object pool = this.getField((PoolingHttpClientConnectionManager)connectionManager, "pool");
        BDDAssertions.then((Long)((Long)this.getField(pool, "timeToLive"))).isEqualTo((Object)new Long(56L));
        TimeUnit timeUnit = (TimeUnit)((Object)this.getField(pool, "tunit"));
        BDDAssertions.then((Comparable)((Object)timeUnit)).isEqualTo((Object)TimeUnit.DAYS);
    }

    @Test
    public void newConnectionManagerWithSSL() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6);
        Lookup<ConnectionSocketFactory> socketFactoryRegistry = this.getConnectionSocketFactoryLookup(connectionManager);
        BDDAssertions.then((Object)socketFactoryRegistry.lookup("https")).isNotNull();
        BDDAssertions.then((Object[])this.getX509TrustManager(socketFactoryRegistry).getAcceptedIssuers()).isNotNull();
    }

    @Test
    public void newConnectionManagerWithDisabledSSLValidation() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(true, 2, 6);
        Lookup<ConnectionSocketFactory> socketFactoryRegistry = this.getConnectionSocketFactoryLookup(connectionManager);
        BDDAssertions.then((Object)socketFactoryRegistry.lookup("https")).isNotNull();
        BDDAssertions.then((Object[])this.getX509TrustManager(socketFactoryRegistry).getAcceptedIssuers()).isNull();
    }

    private Lookup<ConnectionSocketFactory> getConnectionSocketFactoryLookup(HttpClientConnectionManager connectionManager) {
        DefaultHttpClientConnectionOperator connectionOperator = (DefaultHttpClientConnectionOperator)this.getField(connectionManager, "connectionOperator");
        return (Lookup)this.getField(connectionOperator, "socketFactoryRegistry");
    }

    private X509TrustManager getX509TrustManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry) {
        ConnectionSocketFactory connectionSocketFactory = (ConnectionSocketFactory)socketFactoryRegistry.lookup("https");
        SSLSocketFactory sslSocketFactory = (SSLSocketFactory)this.getField(connectionSocketFactory, "socketfactory");
        SSLContextSpi sslContext = (SSLContextSpi)this.getField(sslSocketFactory, "context");
        return (X509TrustManager)this.getField(sslContext, "trustManager");
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

