/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientFactory;
import org.springframework.cloud.commons.httpclient.MyApplication;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={MyApplication.class}, properties={"spring.cloud.httpclient.ok.enabled: true"})
public class DefaultHttpClientConfigurationTests {
    @Autowired
    ApacheHttpClientFactory httpClientFactory;
    @Autowired
    ApacheHttpClientConnectionManagerFactory connectionManagerFactory;
    @Autowired
    OkHttpClientFactory okHttpClientFactory;
    @Autowired
    OkHttpClientConnectionPoolFactory okHttpClientConnectionPoolFactory;

    @Test
    public void connManFactory() throws Exception {
        BDDAssertions.then((boolean)ApacheHttpClientConnectionManagerFactory.class.isInstance(this.connectionManagerFactory)).isTrue();
        BDDAssertions.then((boolean)DefaultApacheHttpClientConnectionManagerFactory.class.isInstance(this.connectionManagerFactory)).isTrue();
    }

    @Test
    public void apacheHttpClientFactory() throws Exception {
        BDDAssertions.then((boolean)ApacheHttpClientFactory.class.isInstance(this.httpClientFactory)).isTrue();
        BDDAssertions.then((boolean)DefaultApacheHttpClientFactory.class.isInstance(this.httpClientFactory)).isTrue();
    }

    @Test
    public void connPoolFactory() throws Exception {
        BDDAssertions.then((boolean)OkHttpClientConnectionPoolFactory.class.isInstance(this.okHttpClientConnectionPoolFactory)).isTrue();
        BDDAssertions.then((boolean)DefaultOkHttpClientConnectionPoolFactory.class.isInstance(this.okHttpClientConnectionPoolFactory)).isTrue();
    }

    @Test
    public void setOkHttpClientFactory() throws Exception {
        BDDAssertions.then((boolean)OkHttpClientFactory.class.isInstance(this.okHttpClientFactory)).isTrue();
        BDDAssertions.then((boolean)DefaultOkHttpClientFactory.class.isInstance(this.okHttpClientFactory)).isTrue();
    }
}

