/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultOkHttpClientFactoryTest {
    @Test
    public void create() throws Exception {
        DefaultOkHttpClientFactory okHttpClientFactory = new DefaultOkHttpClientFactory(new OkHttpClient.Builder());
        DefaultOkHttpClientConnectionPoolFactory poolFactory = new DefaultOkHttpClientConnectionPoolFactory();
        ConnectionPool pool = poolFactory.create(4, 5L, TimeUnit.DAYS);
        OkHttpClient httpClient = okHttpClientFactory.createBuilder(true).connectTimeout(2L, TimeUnit.MILLISECONDS).readTimeout(3L, TimeUnit.HOURS).followRedirects(true).connectionPool(pool).build();
        int connectTimeout = (Integer)this.getField(httpClient, "connectTimeout");
        BDDAssertions.then((int)connectTimeout).isEqualTo(2);
        int readTimeout = (Integer)this.getField(httpClient, "readTimeout");
        BDDAssertions.then((int)readTimeout).isEqualTo(TimeUnit.HOURS.toMillis(3L));
        boolean followRedirects = (Boolean)this.getField(httpClient, "followRedirects");
        BDDAssertions.then((boolean)followRedirects).isTrue();
        ConnectionPool poolFromClient = (ConnectionPool)this.getField(httpClient, "connectionPool");
        BDDAssertions.then((Object)poolFromClient).isEqualTo((Object)pool);
        HostnameVerifier hostnameVerifier = (HostnameVerifier)this.getField(httpClient, "hostnameVerifier");
        BDDAssertions.then((boolean)OkHttpClientFactory.TrustAllHostnames.class.isInstance(hostnameVerifier)).isTrue();
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

