/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.BDDAssertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.core.env.PropertyResolver;
import org.springframework.mock.env.MockEnvironment;

public class IdUtilsTests {
    public static final String DEFAULT_ID = "id1";
    private MockEnvironment env;

    @Before
    public void setup() {
        this.env = new MockEnvironment();
    }

    @After
    public void destroy() {
        this.env = null;
    }

    @Test
    public void emptyEnvironmentWorks() {
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        ((AbstractStringAssert)BDDAssertions.then((String)instanceId).as("instanceId was not null", new Object[0])).isNull();
    }

    @Test
    public void vcapInstanceIdWorks() {
        this.env.setProperty("vcap.application.instance_id", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void hostnameWorks() {
        this.env.setProperty("spring.cloud.client.hostname", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void appNameWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void hostnameAndAppNameWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        this.env.setProperty("spring.cloud.client.hostname", "id12");
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        ((AbstractStringAssert)BDDAssertions.then((String)instanceId).as("instanceId was wrong", new Object[0])).isEqualTo("id12:id1");
    }

    @Test
    public void instanceIdWorks() {
        this.env.setProperty("spring.cloud.client.hostname", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void portWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void appNameAndPortWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        this.env.setProperty("server.port", "80");
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)"id1:80").isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void fullWorks() {
        this.env.setProperty("spring.cloud.client.hostname", "myhost");
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        this.env.setProperty("server.port", "80");
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)"myhost:id1:80").isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }
}

