/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.boot.test.system.OutputCaptureRule;
import org.springframework.cloud.configuration.CompatibilityNotMetException;
import org.springframework.cloud.configuration.CompatibilityVerifier;
import org.springframework.cloud.configuration.CompositeCompatibilityVerifier;
import org.springframework.cloud.configuration.VerificationResult;

public class CompatibilityVerifierTests {
    @Rule
    public OutputCaptureRule outputCapture = new OutputCaptureRule();

    @Test
    public void should_not_print_the_report_when_no_errors_were_found() {
        CompositeCompatibilityVerifier verifier = new CompositeCompatibilityVerifier(new ArrayList());
        verifier.verifyDependencies();
        BDDAssertions.then((String)this.outputCapture.toString()).doesNotContain(new CharSequence[]{"SPRING CLOUD VERIFICATION FAILED"});
    }

    @Test
    public void should_print_the_report_when_errors_were_found() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new CompatibilityVerifier(){

            public VerificationResult verify() {
                return VerificationResult.notCompatible((String)"Wrong Boot version", (String)"Use Boot version 1.2");
            }
        });
        list.add(new CompatibilityVerifier(){

            public VerificationResult verify() {
                return VerificationResult.notCompatible((String)"Wrong JDK version", (String)"Use JDK 25");
            }
        });
        CompositeCompatibilityVerifier verifier = new CompositeCompatibilityVerifier(list);
        try {
            verifier.verifyDependencies();
            BDDAssertions.fail((String)"should fail");
        }
        catch (CompatibilityNotMetException ex) {
            BDDAssertions.then((List)ex.results).hasSize(2);
        }
    }
}

