/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import io.awspring.cloud.s3.InMemoryBufferingS3OutputStreamProvider;
import io.awspring.cloud.s3.PropertiesS3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.S3ProtocolResolver;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.json.JSONException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.util.TestSocketUtils;
import org.springframework.web.client.RestTemplate;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

@Testcontainers
public class AwsS3IntegrationTests {
    private static final Log LOG = LogFactory.getLog(AwsS3IntegrationTests.class);
    private static final int configServerPort = TestSocketUtils.findAvailableTcpPort();
    @Container
    static LocalStackContainer localstack = new LocalStackContainer(DockerImageName.parse((String)"localstack/localstack:1.3.1")).withServices(new LocalStackContainer.Service[]{LocalStackContainer.Service.S3});
    private static ConfigurableApplicationContext server;

    @BeforeAll
    public static void startConfigServer() throws IOException, InterruptedException, JSONException {
        System.setProperty("aws.accessKeyId", localstack.getAccessKey());
        System.setProperty("aws.secretAccessKey", localstack.getSecretKey());
        server = SpringApplication.run((Class[])new Class[]{TestConfigServerApplication.class, S3AutoConfiguration.class}, (String[])new String[]{"--spring.config.name=server", "--spring.profiles.active=awss3", "--server.port=" + configServerPort, "--spring.cloud.config.server.awss3.endpoint=" + localstack.getEndpointOverride(LocalStackContainer.Service.S3).toString(), "--spring.cloud.config.server.awss3.bucket=test-bucket", "--spring.cloud.config.server.awss3.region=" + localstack.getRegion(), "--spring.cloud.aws.endpoint=" + localstack.getEndpointOverride(LocalStackContainer.Service.S3).toString(), "--spring.cloud.aws.region.static=" + localstack.getRegion(), "--logging.level.org.springframework.cloud.config.server.environment=DEBUG", "--debug=true"});
        S3Client s3Client = (S3Client)server.getBean(S3Client.class);
        CreateBucketResponse bucketResponse = s3Client.createBucket(request -> request.bucket("test-bucket"));
        LOG.info((Object)("bucket response " + bucketResponse));
        PutObjectResponse objectResponse = s3Client.putObject(request -> request.bucket("test-bucket").key("data.txt"), RequestBody.fromString((String)"this is a test"));
        LOG.info((Object)("object response " + objectResponse));
        objectResponse = s3Client.putObject(request -> request.bucket("test-bucket").key("main/data.txt"), RequestBody.fromString((String)"this is a test in main"));
        LOG.info((Object)("object response " + objectResponse));
        objectResponse = s3Client.putObject(request -> request.bucket("test-bucket").key("application.properties"), RequestBody.fromString((String)"foo=1"));
        LOG.info((Object)("object response " + objectResponse));
        objectResponse = s3Client.putObject(request -> request.bucket("test-bucket").key("data.properties"), RequestBody.fromString((String)"bar=1"));
        LOG.info((Object)("object response " + objectResponse));
        objectResponse = s3Client.putObject(request -> request.bucket("test-bucket").key("data-dev.properties"), RequestBody.fromString((String)"bar=1"));
        LOG.info((Object)("object response " + objectResponse));
    }

    @AfterAll
    public static void after() {
        server.close();
        System.clearProperty("aws.accessKeyId");
        System.clearProperty("aws.secretAccessKey");
    }

    @Test
    public void context() throws IOException {
        RestTemplate rest = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        String configServerUrl = "http://localhost:" + configServerPort;
        Environment env = (Environment)rest.getForObject(configServerUrl + "/application/default", Environment.class, new Object[0]);
        Assertions.assertThat(((PropertySource)env.getPropertySources().get(0)).getSource().get("foo")).isEqualTo((Object)"1");
        Assertions.assertThat((String)((String)rest.getForObject(configServerUrl + "/application/default/main/data.txt", String.class, new Object[0]))).isEqualTo("this is a test in main");
        Assertions.assertThat((String)((String)rest.getForObject(configServerUrl + "/application/default/data.txt?useDefaultLabel", String.class, new Object[0]))).isEqualTo("this is a test");
    }

    @Test
    public void defaultApplicationAndProfileIncluded() throws IOException {
        RestTemplate rest = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        String configServerUrl = "http://localhost:" + configServerPort;
        Environment env = (Environment)rest.getForObject(configServerUrl + "/data/dev", Environment.class, new Object[0]);
        Assertions.assertThat((List)env.getPropertySources()).hasSize(3);
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(0)).getName()).isEqualTo("s3:data-dev");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(1)).getName()).isEqualTo("s3:data");
        Assertions.assertThat((String)((PropertySource)env.getPropertySources().get(2)).getName()).isEqualTo("s3:application");
    }

    @Import(value={S3ProtocolResolver.class})
    static class S3AutoConfiguration {
        S3AutoConfiguration() {
        }

        @Bean
        S3Client s3Client() {
            return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)localstack.getRegion()))).endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.S3))).build();
        }

        @Bean
        S3OutputStreamProvider inMemoryBufferingS3StreamProvider(S3Client s3Client, Optional<S3ObjectContentTypeResolver> contentTypeResolver) {
            return new InMemoryBufferingS3OutputStreamProvider(s3Client, contentTypeResolver.orElseGet(PropertiesS3ObjectContentTypeResolver::new));
        }
    }
}

