/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.cloud.bootstrap.enabled=true", "logging.level.org.springframework.boot.context.config=TRACE", "spring.cloud.bootstrap.name:enable-bootstrap", "encrypt.rsa.algorithm=DEFAULT", "encrypt.rsa.strong=false"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test", "encrypt"})
public class BootstrapConfigServerIntegrationTests {
    @LocalServerPort
    private int port;
    @Autowired
    ConfigurableEnvironment env;

    @BeforeAll
    public static void init() throws IOException {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
        ConfigServerTestUtils.prepareLocalRepo("encrypt-repo");
    }

    @Test
    public void contextLoads() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Environment environment = (Environment)response.getBody();
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(2);
        ConfigServerTestUtils.assertOriginTrackedValue(environment, 0, "bar", "foo");
        ConfigServerTestUtils.assertOriginTrackedValue(environment, 1, "info.foo", "bar");
    }

    @Test
    @Disabled
    public void environmentBootstraps() {
        Assertions.assertThat((String)this.env.getProperty("info.foo", "")).isEqualTo("bar");
        Assertions.assertThat((String)this.env.getProperty("config.foo", "")).isEqualTo("foo");
    }
}

