/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.WebApplicationContextRunner;
import org.springframework.cloud.config.server.composite.CompositeUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.cloud.test.ClassPathExclusions;
import org.springframework.core.env.Environment;

public class CompositeClasspathTests {

    @ClassPathExclusions(value={"google-auth-library-oauth2-http-*.jar"})
    public static class GoogleAuthTests {
        @Test
        public void contextLoads() {
            ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.jmx.enabled=false", "spring.config.name:configserver", "spring.cloud.config.server.composite[0].uri:https://source.developers.google.com", "spring.cloud.config.server.composite[0].type:git"})).run(context -> CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment()));
        }
    }

    @ClassPathExclusions(value={"org.eclipse.jgit-*.jar"})
    public static class JGitTests {
        @Test
        public void contextLoads() {
            ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.jmx.enabled=false", "spring.config.name:compositeconfigserver", "spring.cloud.config.server.composite[0].uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.composite[0].type:svn", "spring.cloud.config.server.composite[1].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[1].type:native"})).run(context -> CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment()));
        }
    }

    @ClassPathExclusions(value={"svnkit-*.jar"})
    public static class SvnTests {
        @Test
        public void contextLoads() {
            ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.jmx.enabled=false", "spring.config.name:compositeconfigserver", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[0].type:git", "spring.cloud.config.server.composite[1].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[1].type:native"})).run(context -> CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment()));
        }
    }

    @ClassPathExclusions(value={"httpclient-*.jar"})
    public static class HttpClientTests {
        @Test
        public void contextLoads() {
            ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.jmx.enabled=false", "spring.config.name:compositeconfigserver", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[0].type:git", "spring.cloud.config.server.composite[1].uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.composite[1].type:svn"})).run(context -> CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment()));
        }
    }

    @ClassPathExclusions(value={"spring-jdbc-*.jar", "spring-data-redis-*.jar", "spring-boot-actuator-*.jar"})
    public static class NoActuatorTests {
        @Test
        public void contextLoads() {
            ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.jmx.enabled=false", "spring.config.name:compositeconfigserver", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[0].type:git"})).run(context -> {
                CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment());
                ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).doesNotHaveBean("configServerHealthIndicator");
            });
        }
    }

    @ClassPathExclusions(value={"spring-jdbc-*.jar", "spring-data-redis-*.jar"})
    public static class JdbcTests {
        @Test
        public void contextLoads() {
            ((WebApplicationContextRunner)((WebApplicationContextRunner)new WebApplicationContextRunner().withUserConfiguration(new Class[]{TestConfigServerApplication.class})).withPropertyValues(new String[]{"spring.profiles.active:test,composite", "spring.jmx.enabled=false", "spring.config.name:compositeconfigserver", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[0].type:git", "spring.cloud.config.server.composite[1].uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.composite[1].type:svn"})).run(context -> CompositeUtils.getCompositeTypeList((Environment)context.getEnvironment()));
        }
    }
}

