/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;

public class CompositeIntegrationTests {

    @SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.name:compositeconfigserver", "spring.cloud.config.server.composite[0].uri:file:./target/repos/config-repo", "spring.cloud.config.server.composite[0].type:git", "spring.cloud.config.server.composite[1].uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.composite[1].type:svn"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "composite"})
    public static class ListTests {
        @LocalServerPort
        private int port;

        @BeforeAll
        public static void init() throws Exception {
            SystemReader.setInstance((SystemReader)new MockSystemReader());
            ConfigServerTestUtils.prepareLocalRepo();
            ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/repos/svn-config-repo");
        }

        @Test
        public void contextLoads() {
            ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
            Environment environment = (Environment)response.getBody();
            Assertions.assertThat((List)environment.getPropertySources()).hasSize(3);
            Assertions.assertThat((String)"overrides").isEqualTo(((PropertySource)environment.getPropertySources().get(0)).getName());
            Assertions.assertThat((((PropertySource)environment.getPropertySources().get(1)).getName().contains("config-repo") && !((PropertySource)environment.getPropertySources().get(1)).getName().contains("svn-config-repo") ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(2)).getName()).contains(new CharSequence[]{"svn-config-repo"});
            ConfigServerTestUtils.assertConfigEnabled(environment);
        }

        @Test
        public void resourceEndpointsWork() {
            String text = (String)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development/composite/bar.properties", String.class, new Object[0]);
            String expected = "foo: barconfig\n";
            Assertions.assertThat((String)expected).isEqualTo(text).as("invalid content", new Object[0]);
            text = (String)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development/composite/bar.properties", String.class, new Object[0]);
            Assertions.assertThat((String)expected).isEqualTo(text).as("invalid content", new Object[0]);
        }
    }

    @SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.name:compositeconfigserver", "spring.cloud.config.server.svn.uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.svn.order:2", "spring.cloud.config.server.git.uri:file:./target/repos/config-repo", "spring.cloud.config.server.git.order:1", "spring.cloud.config.server.reverseLocationOrder:true"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "git", "subversion"})
    public static class ReverseLocationOrderTest {
        @LocalServerPort
        private int port;

        @BeforeAll
        public static void init() throws Exception {
            SystemReader.setInstance((SystemReader)new MockSystemReader());
            ConfigServerTestUtils.prepareLocalRepo();
            ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/repos/svn-config-repo");
        }

        @Test
        public void resourceEndpointsWork() {
            String text = (String)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development/composite/bar.properties", String.class, new Object[0]);
            String expected = "foo: bar";
            Assertions.assertThat((String)expected).isEqualTo(text).as("invalid content", new Object[0]);
        }
    }

    @SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.name:compositeconfigserver", "spring.cloud.config.server.svn.uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.svn.order:2", "spring.cloud.config.server.git.uri:file:./target/repos/config-repo", "spring.cloud.config.server.git.order:1"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
    @ActiveProfiles(value={"test", "git", "subversion"})
    public static class StaticTests {
        @LocalServerPort
        private int port;

        @BeforeAll
        public static void init() throws Exception {
            SystemReader.setInstance((SystemReader)new MockSystemReader());
            ConfigServerTestUtils.prepareLocalRepo();
            ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/repos/svn-config-repo");
        }

        @Test
        public void contextLoads() {
            ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
            Environment environment = (Environment)response.getBody();
            Assertions.assertThat((int)3).isEqualTo(environment.getPropertySources().size());
            Assertions.assertThat((String)"overrides").isEqualTo(((PropertySource)environment.getPropertySources().get(0)).getName());
            Assertions.assertThat((((PropertySource)environment.getPropertySources().get(1)).getName().contains("config-repo") && !((PropertySource)environment.getPropertySources().get(1)).getName().contains("svn-config-repo") ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(2)).getName()).contains(new CharSequence[]{"svn-config-repo"});
            ConfigServerTestUtils.assertConfigEnabled(environment);
        }

        @Test
        public void resourceEndpointsWork() {
            String text = (String)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development/composite/bar.properties", String.class, new Object[0]);
            String expected = "foo: barconfig\n";
            Assertions.assertThat((String)expected).isEqualTo(text).as("invalid content", new Object[0]);
        }
    }
}

