/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.name:configserver"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test", "native"})
public class ConfigClientBackwardsCompatibilityIntegrationTests {
    @LocalServerPort
    private int port;
    @Autowired
    private ApplicationContext context;

    @BeforeAll
    public static void init() throws IOException {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
        ConfigServerTestUtils.prepareLocalRepo();
    }

    @Test
    public void testBackwardsCompatibleFormat() {
        Map environment = (Map)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development", Map.class, new Object[0]);
        Object value = this.getPropertySourceValue(environment);
        ((ObjectAssert)Assertions.assertThat((Object)value).isInstanceOf(String.class)).isEqualTo((Object)"true");
    }

    @Test
    public void testBackwardsCompatibleFormatWithLabel() {
        Map environment = (Map)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development/master", Map.class, new Object[0]);
        Object value = this.getPropertySourceValue(environment);
        ((ObjectAssert)Assertions.assertThat((Object)value).isInstanceOf(String.class)).isEqualTo((Object)"true");
    }

    @Test
    public void testNewFormat() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Map.class, new Object[0]);
        Object value = this.getPropertySourceValue((Map)response.getBody());
        Assertions.assertThat((Object)value).isInstanceOf(Map.class);
        Map valueMap = (Map)Map.class.cast(value);
        Assertions.assertThat((Map)valueMap).containsEntry((Object)"value", (Object)"true");
    }

    @Test
    public void testNewFormatWithLabel() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development/master", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Map.class, new Object[0]);
        Object value = this.getPropertySourceValue((Map)response.getBody());
        Assertions.assertThat((Object)value).isInstanceOf(Map.class);
        Map valueMap = (Map)Map.class.cast(value);
        Assertions.assertThat((Map)valueMap).containsEntry((Object)"value", (Object)"true");
    }

    private Object getPropertySourceValue(Map environment) {
        Assertions.assertThat((Map)environment).isNotNull();
        Assertions.assertThat((Map)environment).containsKey((Object)"propertySources");
        List propertySources = (List)environment.get("propertySources");
        Assertions.assertThat((List)propertySources).hasSizeGreaterThan(1);
        Map source = (Map)propertySources.get(0);
        Assertions.assertThat((Map)source).containsKeys(new Object[]{"source"});
        Map sourceValue = (Map)source.get("source");
        Assertions.assertThat((Map)sourceValue).containsKeys(new Object[]{"spring.cloud.config.enabled"});
        return sourceValue.get("spring.cloud.config.enabled");
    }
}

