/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(classes={TestConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
public class ConfigClientOffIntegrationTests {
    @LocalServerPort
    private int port;
    @Autowired
    private ApplicationContext context;

    @BeforeAll
    public static void init() throws IOException {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
        ConfigServerTestUtils.prepareLocalRepo();
    }

    @Test
    public void contextLoads() {
        Environment environment = (Environment)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/foo/development/", Environment.class, new Object[0]);
        Assertions.assertThat((List)environment.getPropertySources()).isEmpty();
    }

    @Test
    public void configClientDisabled() throws Exception {
        Assertions.assertThat((int)BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.context, ConfigServicePropertySourceLocator.class).length).isEqualTo(0);
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={TestConfigServerApplication.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }

        @Bean
        public EnvironmentRepository environmentRepository() {
            EnvironmentRepository repository = (EnvironmentRepository)Mockito.mock(EnvironmentRepository.class);
            BDDMockito.given((Object)repository.findOne(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).willReturn((Object)new Environment("", new String[]{""}));
            return repository;
        }

        @Bean
        public ResourceRepository resourceRepository() {
            ResourceRepository repository = (ResourceRepository)Mockito.mock(ResourceRepository.class);
            BDDMockito.given((Object)repository.findOne(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).willReturn((Object)new ByteArrayResource("".getBytes()));
            return repository;
        }
    }
}

