/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.CredhubIntegrationTest;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;

@SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.profiles.active:composite", "spring.cloud.config.server.composite[0].type:credhub", "spring.cloud.config.server.composite[0].url:https://credhub:8844"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class CredhubCompositeConfigServerIntegrationTests
extends CredhubIntegrationTest {
    @LocalServerPort
    private int port;

    @Test
    public void shouldRetrieveValuesFromCredhub() {
        Environment environment = (Environment)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForObject("http://localhost:" + this.port + "/myapp/master/default", Environment.class, new Object[0]);
        Assertions.assertThat((List)environment.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("credhub-myapp-master-default");
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getSource().toString()).isEqualTo("{key=value}");
    }
}

