/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.Collections;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.credhub.core.credential.CredHubCredentialOperations;
import org.springframework.credhub.support.CredentialDetails;
import org.springframework.credhub.support.CredentialName;
import org.springframework.credhub.support.CredentialSummary;
import org.springframework.credhub.support.CredentialType;
import org.springframework.credhub.support.SimpleCredentialName;
import org.springframework.credhub.support.json.JsonCredential;

public class CredhubIntegrationTest {
    @MockBean
    private CredHubOperations credHubOperations;

    @BeforeEach
    public void setUp() {
        CredHubCredentialOperations credhubCredentialOperations = (CredHubCredentialOperations)Mockito.mock(CredHubCredentialOperations.class);
        String expectedPath = "/myapp/master/default";
        SimpleCredentialName togglesCredentialName = new SimpleCredentialName(new String[]{expectedPath + "/toggles"});
        Mockito.when((Object)credhubCredentialOperations.findByPath(expectedPath)).thenReturn(Collections.singletonList(new CredentialSummary((CredentialName)togglesCredentialName)));
        JsonCredential credentials = new JsonCredential();
        credentials.put((Object)"key", (Object)"value");
        Mockito.when((Object)credhubCredentialOperations.getByName((CredentialName)new SimpleCredentialName(new String[]{expectedPath + "/toggles"}), JsonCredential.class)).thenReturn((Object)new CredentialDetails("id1", (CredentialName)togglesCredentialName, CredentialType.JSON, (Object)credentials));
        Mockito.when((Object)this.credHubOperations.credentials()).thenReturn((Object)credhubCredentialOperations);
    }
}

