/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(classes={TestConfigServerApplication.class}, properties={"spring.config.name:configserver"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test", "native"})
public class NativeConfigServerIntegrationTests {
    @LocalServerPort
    private int port;

    @BeforeAll
    public static void init() throws IOException {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
        ConfigServerTestUtils.prepareLocalRepo();
    }

    @Test
    public void contextLoads() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Environment environment = (Environment)response.getBody();
        Assertions.assertThat((List)environment.getPropertySources()).isNotEmpty();
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("overrides");
        ConfigServerTestUtils.assertConfigEnabled(environment);
    }

    @Test
    public void testConfigServerDoesNotReturnItsOwnConfiguration() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/configserver/default", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Environment environment = (Environment)response.getBody();
        Assertions.assertThat((List)environment.getPropertySources()).isNotEmpty();
        Assertions.assertThat((List)environment.getPropertySources()).hasSize(1);
        Assertions.assertThat((String)((PropertySource)environment.getPropertySources().get(0)).getName()).isEqualTo("overrides");
        ConfigServerTestUtils.assertConfigEnabled(environment);
    }

    @Test
    public void badYaml() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForEntity("http://localhost:" + this.port + "/bad/default", String.class, new Object[0]);
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

