/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import brave.sampler.Sampler;
import brave.test.TestSpanHandler;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.tck.MeterRegistryAssert;
import io.micrometer.tracing.brave.bridge.BraveFinishedSpan;
import io.micrometer.tracing.exporter.FinishedSpan;
import io.micrometer.tracing.test.simple.SpansAssert;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.cloud.config.server.test.TestConfigServerApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ActiveProfiles;

@AutoConfigureObservability
@SpringBootTest(classes={TestConfigServerApplication.class, Config.class}, properties={"spring.application.name:config-server", "spring.config.name:compositeconfigserver", "spring.cloud.config.server.svn.uri:file:///./target/repos/svn-config-repo", "spring.cloud.config.server.svn.order:2", "spring.cloud.config.server.git.uri:file:./target/repos/config-repo", "spring.cloud.config.server.git.order:1"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test", "git", "subversion"})
class ObservationIntegrationTests {
    @LocalServerPort
    private int port;
    @Autowired
    TestSpanHandler testSpanHandler;
    @Autowired
    MeterRegistry meterRegistry;

    ObservationIntegrationTests() {
    }

    @BeforeAll
    public static void init() throws Exception {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
        ConfigServerTestUtils.prepareLocalRepo();
        ConfigServerTestUtils.prepareLocalSvnRepo("src/test/resources/svn-config-repo", "target/repos/svn-config-repo");
    }

    @Test
    void testSuccessfulObservation() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Environment environment = (Environment)response.getBody();
        Assertions.assertThat((Object)environment).isNotNull();
        ConfigServerTestUtils.assertConfigEnabled(environment);
        List<FinishedSpan> finishedSpans = this.finishedSpans();
        SpansAssert.then(finishedSpans).hasASpanWithNameIgnoreCase("env find", spanAssert -> spanAssert.hasTag("spring.cloud.config.environment.application", "foo").hasTag("spring.cloud.config.environment.profile", "development").hasTag("spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.SearchPathCompositeEnvironmentRepository")).hasASpanWithNameIgnoreCase("env find", spanAssert -> spanAssert.hasTag("spring.cloud.config.environment.application", "foo").hasTag("spring.cloud.config.environment.profile", "development").hasTag("spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository")).hasASpanWithNameIgnoreCase("env find", spanAssert -> spanAssert.hasTag("spring.cloud.config.environment.application", "foo").hasTag("spring.cloud.config.environment.profile", "development").hasTag("spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository")).hasASpanWithNameIgnoreCase("env find", spanAssert -> spanAssert.hasTag("spring.cloud.config.environment.application", "foo").hasTag("spring.cloud.config.environment.profile", "development").hasTag("spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.PassthruEnvironmentRepository"));
        MeterRegistryAssert.then((MeterRegistry)this.meterRegistry).hasTimerWithNameAndTags("spring.cloud.config.environment.find", KeyValues.of((String[])new String[]{"spring.cloud.config.environment.application", "foo", "spring.cloud.config.environment.profile", "development", "spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.SearchPathCompositeEnvironmentRepository"})).hasTimerWithNameAndTags("spring.cloud.config.environment.find", KeyValues.of((String[])new String[]{"spring.cloud.config.environment.application", "foo", "spring.cloud.config.environment.profile", "development", "spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository"})).hasTimerWithNameAndTags("spring.cloud.config.environment.find", KeyValues.of((String[])new String[]{"spring.cloud.config.environment.application", "foo", "spring.cloud.config.environment.profile", "development", "spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository"})).hasTimerWithNameAndTags("spring.cloud.config.environment.find", KeyValues.of((String[])new String[]{"spring.cloud.config.environment.application", "foo", "spring.cloud.config.environment.profile", "development", "spring.cloud.config.environment.class", "org.springframework.cloud.config.server.environment.PassthruEnvironmentRepository"}));
    }

    private List<FinishedSpan> finishedSpans() {
        return this.testSpanHandler.spans().stream().map(BraveFinishedSpan::fromBrave).collect(Collectors.toList());
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }

        @Bean
        TestSpanHandler testSpanHandler() {
            return new TestSpanHandler();
        }

        @Bean
        Sampler sampler() {
            return Sampler.ALWAYS_SAMPLE;
        }
    }
}

