/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.util.SystemReader;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.EnableConfigServer;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.test.ConfigServerTestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.util.MultiValueMap;

@SpringBootTest(classes={TestConfiguration.class}, properties={"spring.cloud.config.enabled=true", "spring.cloud.bootstrap.enabled=true", "management.endpoint.env.post.enabled=true", "management.endpoints.web.exposure.include=env, refresh"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"test"})
@DirtiesContext
public class RefreshableConfigServerIntegrationTests {
    private static String localRepo = null;
    @LocalServerPort
    private int port;

    @BeforeAll
    public static void init() throws IOException {
        SystemReader.setInstance((SystemReader)new MockSystemReader());
        localRepo = ConfigServerTestUtils.prepareLocalRepo();
    }

    @AfterAll
    public static void after() throws IOException {
        ConfigServerTestUtils.deleteLocalRepo(localRepo);
    }

    @Test
    public void refreshOverrides() {
        ResponseEntity entity = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        Environment environment = (Environment)entity.getBody();
        Assertions.assertThat((List)environment.getPropertySources()).isEmpty();
        String actuatorEndpoint = "http://localhost:" + this.port + "/actuator";
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity request = new HttpEntity((Object)"{\"name\": \"spring.cloud.config.server.overrides.foo\", \"value\": \"bar\"}", (MultiValueMap)headers);
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).postForEntity(actuatorEndpoint + "/env", (Object)request, Void.class, new Object[0]);
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).postForEntity(actuatorEndpoint + "/refresh", null, Void.class, new Object[0]);
        Assertions.assertThat((Object)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        entity = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange("http://localhost:" + this.port + "/foo/development", HttpMethod.GET, ConfigServerTestUtils.getV2AcceptEntity(), Environment.class, new Object[0]);
        environment = (Environment)entity.getBody();
        Assertions.assertThat((List)environment.getPropertySources()).isNotEmpty();
        ConfigServerTestUtils.assertOriginTrackedValue(environment, 0, "foo", "bar");
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableConfigServer
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }

        @Bean
        public EnvironmentRepository environmentRepository() {
            EnvironmentRepository repository = (EnvironmentRepository)Mockito.mock(EnvironmentRepository.class);
            Environment environment = new Environment("", new String[]{""});
            BDDMockito.given((Object)repository.findOne((String)ArgumentMatchers.isA(String.class), (String)ArgumentMatchers.isA(String.class), (String)ArgumentMatchers.nullable(String.class), ((Boolean)ArgumentMatchers.isA(Boolean.class)).booleanValue())).willReturn((Object)environment);
            return repository;
        }

        @Bean
        public ResourceRepository resourceRepository() {
            ResourceRepository repository = (ResourceRepository)Mockito.mock(ResourceRepository.class);
            BDDMockito.given((Object)repository.findOne((String)ArgumentMatchers.isA(String.class), (String)ArgumentMatchers.isA(String.class), (String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.isA(String.class))).willReturn((Object)new ByteArrayResource("".getBytes()));
            return repository;
        }
    }
}

